package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DigitalWalletAllOf
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-04-20T13:56:27.293162365Z[Etc/UTC]")
public class DigitalWalletAllOf   {

  @JsonProperty("digitalWalletId")
  private String digitalWalletId;

  @JsonProperty("digitalWalletProvider")
  private String digitalWalletProvider;

  public DigitalWalletAllOf digitalWalletId(String digitalWalletId) {
    this.digitalWalletId = digitalWalletId;
    return this;
  }

  /**
   * Идентификатор кошелька
   * @return digitalWalletId
  */
  @NotNull @Size(min = 16, max = 256) 
  @Schema(name = "digitalWalletId", example = "zu3TcwGI71Bpaaw2XkLWZXlhMdn4zpVzMQ", description = "Идентификатор кошелька", required = true)
  public String getDigitalWalletId() {
    return digitalWalletId;
  }

  public void setDigitalWalletId(String digitalWalletId) {
    this.digitalWalletId = digitalWalletId;
  }

  public DigitalWalletAllOf digitalWalletProvider(String digitalWalletProvider) {
    this.digitalWalletProvider = digitalWalletProvider;
    return this;
  }

  /**
   * Провайдер электронных денежных средств
   * @return digitalWalletProvider
  */
  @NotNull 
  @Schema(name = "digitalWalletProvider", example = "Paypal", description = "Провайдер электронных денежных средств", required = true)
  public String getDigitalWalletProvider() {
    return digitalWalletProvider;
  }

  public void setDigitalWalletProvider(String digitalWalletProvider) {
    this.digitalWalletProvider = digitalWalletProvider;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DigitalWalletAllOf digitalWalletAllOf = (DigitalWalletAllOf) o;
    return Objects.equals(this.digitalWalletId, digitalWalletAllOf.digitalWalletId) &&
        Objects.equals(this.digitalWalletProvider, digitalWalletAllOf.digitalWalletProvider);
  }

  @Override
  public int hashCode() {
    return Objects.hash(digitalWalletId, digitalWalletProvider);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DigitalWalletAllOf {\n");
    sb.append("    digitalWalletId: ").append(toIndentedString(digitalWalletId)).append("\n");
    sb.append("    digitalWalletProvider: ").append(toIndentedString(digitalWalletProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

