/*
 * Vality Wallets. Webhooks Events API
 *  ## Wallet Webhook Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий по кошелькам в рамках вашей организации, которые система доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы API, описанные в спецификации [Vality Webhook Management API](https://github.com/valitydev/swag-wallets). Когда наступает одно из событий в рамках определенного кошелька (например, изменение статуса кошелька), система выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Система гарантирует порядок доставки событий в рамках определенного предмета оповещения (кошелек, пополнение, выплата и т.п.). Система поддерживает очередь сообщений для каждого предмета оповещения, чтобы соблюсти очередность и гарантированную доставку.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Система будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, система будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого кошелька, отбрасываются.  ## Авторизация полученных сообщений  Система подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag.wallets.webhook.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.DestinationAuthorized;
import dev.vality.swag.wallets.webhook.events.model.DestinationCreated;
import dev.vality.swag.wallets.webhook.events.model.DestinationUnauthorized;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalFailed;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalStarted;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalSucceeded;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Данные события
 */
@ApiModel(description = "Данные события")
@JsonPropertyOrder({
  Event.JSON_PROPERTY_EVENT_I_D,
  Event.JSON_PROPERTY_OCCURED_AT,
  Event.JSON_PROPERTY_TOPIC,
  Event.JSON_PROPERTY_EVENT_TYPE
})
@JsonTypeName("Event")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-20T13:56:23.153606718Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "eventType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = DestinationAuthorized.class, name = "DestinationAuthorized"),
  @JsonSubTypes.Type(value = DestinationCreated.class, name = "DestinationCreated"),
  @JsonSubTypes.Type(value = DestinationUnauthorized.class, name = "DestinationUnauthorized"),
  @JsonSubTypes.Type(value = WithdrawalFailed.class, name = "WithdrawalFailed"),
  @JsonSubTypes.Type(value = WithdrawalStarted.class, name = "WithdrawalStarted"),
  @JsonSubTypes.Type(value = WithdrawalSucceeded.class, name = "WithdrawalSucceeded"),
})

public class Event {
  public static final String JSON_PROPERTY_EVENT_I_D = "eventID";
  private String eventID;

  public static final String JSON_PROPERTY_OCCURED_AT = "occuredAt";
  private OffsetDateTime occuredAt;

  /**
   * Предмет оповещения
   */
  public enum TopicEnum {
    WITHDRAWALTOPIC("WithdrawalTopic"),
    
    DESTINATIONTOPIC("DestinationTopic");

    private String value;

    TopicEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TopicEnum fromValue(String value) {
      for (TopicEnum b : TopicEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TOPIC = "topic";
  private TopicEnum topic;

  /**
   * Тип произошедшего с предметом оповещения события
   */
  public enum EventTypeEnum {
    WITHDRAWALSTARTED("WithdrawalStarted"),
    
    WITHDRAWALSUCCEEDED("WithdrawalSucceeded"),
    
    WITHDRAWALFAILED("WithdrawalFailed"),
    
    DESTINATIONCREATED("DestinationCreated"),
    
    DESTINATIONAUTHORIZED("DestinationAuthorized"),
    
    DESTINATIONUNAUTHORIZED("DestinationUnauthorized");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypeEnum fromValue(String value) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
  protected EventTypeEnum eventType;

  public Event() { 
  }

  public Event eventID(String eventID) {
    
    this.eventID = eventID;
    return this;
  }

   /**
   * Идентификатор события в системе
   * @return eventID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Идентификатор события в системе")
  @JsonProperty(JSON_PROPERTY_EVENT_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEventID() {
    return eventID;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventID(String eventID) {
    this.eventID = eventID;
  }


  public Event occuredAt(OffsetDateTime occuredAt) {
    
    this.occuredAt = occuredAt;
    return this;
  }

   /**
   * Дата и время возникновения события
   * @return occuredAt
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Дата и время возникновения события")
  @JsonProperty(JSON_PROPERTY_OCCURED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getOccuredAt() {
    return occuredAt;
  }


  @JsonProperty(JSON_PROPERTY_OCCURED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOccuredAt(OffsetDateTime occuredAt) {
    this.occuredAt = occuredAt;
  }


  public Event topic(TopicEnum topic) {
    
    this.topic = topic;
    return this;
  }

   /**
   * Предмет оповещения
   * @return topic
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Предмет оповещения")
  @JsonProperty(JSON_PROPERTY_TOPIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TopicEnum getTopic() {
    return topic;
  }


  @JsonProperty(JSON_PROPERTY_TOPIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTopic(TopicEnum topic) {
    this.topic = topic;
  }


  public Event eventType(EventTypeEnum eventType) {
    
    this.eventType = eventType;
    return this;
  }

   /**
   * Тип произошедшего с предметом оповещения события
   * @return eventType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Тип произошедшего с предметом оповещения события")
  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EventTypeEnum getEventType() {
    return eventType;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEventType(EventTypeEnum eventType) {
    this.eventType = eventType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Event event = (Event) o;
    return Objects.equals(this.eventID, event.eventID) &&
        Objects.equals(this.occuredAt, event.occuredAt) &&
        Objects.equals(this.topic, event.topic) &&
        Objects.equals(this.eventType, event.eventType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventID, occuredAt, topic, eventType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Event {\n");
    sb.append("    eventID: ").append(toIndentedString(eventID)).append("\n");
    sb.append("    occuredAt: ").append(toIndentedString(occuredAt)).append("\n");
    sb.append("    topic: ").append(toIndentedString(topic)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

