package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Ресурс приёмника денежных средств, используемый для осуществления выводов
 */

@Schema(name = "DestinationResource", description = "Ресурс приёмника денежных средств, используемый для осуществления выводов")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = BankCard.class, name = "BankCard"),
  @JsonSubTypes.Type(value = CryptoWallet.class, name = "CryptoWallet"),
  @JsonSubTypes.Type(value = DigitalWallet.class, name = "DigitalWallet"),
})
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-03-12T19:05:30.960265880Z[Etc/UTC]")
public class DestinationResource   {

  /**
   * Тип ресурса приёмника средств. 
   */
  public enum TypeEnum {
    BANKCARD("BankCard"),
    
    CRYPTOWALLET("CryptoWallet"),
    
    DIGITALWALLET("DigitalWallet");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public DestinationResource type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Тип ресурса приёмника средств. 
   * @return type
  */
  @NotNull 
  @Schema(name = "type", description = "Тип ресурса приёмника средств. ", required = true)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DestinationResource destinationResource = (DestinationResource) o;
    return Objects.equals(this.type, destinationResource.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DestinationResource {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

