package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.CryptoCurrency;
import dev.vality.swag.wallets.webhook.events.model.CryptoWalletAllOf;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Данные криптовалютного кошелька
 */

@Schema(name = "CryptoWallet", description = "Данные криптовалютного кошелька")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-03-12T19:05:30.960265880Z[Etc/UTC]")
public class CryptoWallet extends DestinationResource  {

  @JsonProperty("cryptoWalletId")
  private String cryptoWalletId;

  @JsonProperty("currency")
  private CryptoCurrency currency;

  public CryptoWallet cryptoWalletId(String cryptoWalletId) {
    this.cryptoWalletId = cryptoWalletId;
    return this;
  }

  /**
   * Идентификатор (он же адрес) криптовалютного кошелька
   * @return cryptoWalletId
  */
  @NotNull @Size(min = 16, max = 256) 
  @Schema(name = "cryptoWalletId", example = "zu3TcwGI71Bpaaw2XkLWZXlhMdn4zpVzMQ", description = "Идентификатор (он же адрес) криптовалютного кошелька", required = true)
  public String getCryptoWalletId() {
    return cryptoWalletId;
  }

  public void setCryptoWalletId(String cryptoWalletId) {
    this.cryptoWalletId = cryptoWalletId;
  }

  public CryptoWallet currency(CryptoCurrency currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
  */
  @NotNull @Valid 
  @Schema(name = "currency", required = true)
  public CryptoCurrency getCurrency() {
    return currency;
  }

  public void setCurrency(CryptoCurrency currency) {
    this.currency = currency;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoWallet cryptoWallet = (CryptoWallet) o;
    return Objects.equals(this.cryptoWalletId, cryptoWallet.cryptoWalletId) &&
        Objects.equals(this.currency, cryptoWallet.currency) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cryptoWalletId, currency, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoWallet {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    cryptoWalletId: ").append(toIndentedString(cryptoWalletId)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

