package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.wallets.webhook.events.model.BankCardTokenProvider;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * BankCardAllOf
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-03-12T19:05:30.960265880Z[Etc/UTC]")
public class BankCardAllOf   {

  @JsonProperty("cardNumberMask")
  private String cardNumberMask;

  @JsonProperty("bin")
  private String bin;

  @JsonProperty("lastDigits")
  private String lastDigits;

  @JsonProperty("paymentSystem")
  private String paymentSystem;

  @JsonProperty("tokenProvider")
  private BankCardTokenProvider tokenProvider;

  public BankCardAllOf cardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
    return this;
  }

  /**
   * Маскированый номер карты
   * @return cardNumberMask
  */
  @NotNull @Pattern(regexp = "^\\d{6,8}\\*+\\d{2,4}$") 
  @Schema(name = "cardNumberMask", description = "Маскированый номер карты", required = true)
  public String getCardNumberMask() {
    return cardNumberMask;
  }

  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }

  public BankCardAllOf bin(String bin) {
    this.bin = bin;
    return this;
  }

  /**
   * BIN банка-эмитента карты
   * @return bin
  */
  @Pattern(regexp = "^\\d{6,8}$") 
  @Schema(name = "bin", description = "BIN банка-эмитента карты", required = false)
  public String getBin() {
    return bin;
  }

  public void setBin(String bin) {
    this.bin = bin;
  }

  public BankCardAllOf lastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
    return this;
  }

  /**
   * Последние цифры номера карты
   * @return lastDigits
  */
  @Pattern(regexp = "^\\d{2,4}$") 
  @Schema(name = "lastDigits", description = "Последние цифры номера карты", required = false)
  public String getLastDigits() {
    return lastDigits;
  }

  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }

  public BankCardAllOf paymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
    return this;
  }

  /**
   * Платежная система
   * @return paymentSystem
  */
  @NotNull 
  @Schema(name = "paymentSystem", description = "Платежная система", required = true)
  public String getPaymentSystem() {
    return paymentSystem;
  }

  public void setPaymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
  }

  public BankCardAllOf tokenProvider(BankCardTokenProvider tokenProvider) {
    this.tokenProvider = tokenProvider;
    return this;
  }

  /**
   * Get tokenProvider
   * @return tokenProvider
  */
  @Valid 
  @Schema(name = "tokenProvider", required = false)
  public BankCardTokenProvider getTokenProvider() {
    return tokenProvider;
  }

  public void setTokenProvider(BankCardTokenProvider tokenProvider) {
    this.tokenProvider = tokenProvider;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankCardAllOf bankCardAllOf = (BankCardAllOf) o;
    return Objects.equals(this.cardNumberMask, bankCardAllOf.cardNumberMask) &&
        Objects.equals(this.bin, bankCardAllOf.bin) &&
        Objects.equals(this.lastDigits, bankCardAllOf.lastDigits) &&
        Objects.equals(this.paymentSystem, bankCardAllOf.paymentSystem) &&
        Objects.equals(this.tokenProvider, bankCardAllOf.tokenProvider);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardNumberMask, bin, lastDigits, paymentSystem, tokenProvider);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankCardAllOf {\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

