/*
 * Vality Wallets. Webhooks Events API
 *  ## Wallet Webhook Events API  Данная спецификация определяет протокол доставки оповещений о возникновении новых событий по кошелькам в рамках вашей организации, которые система доставляет в виде HTTP-запросов на URL-адреса созданных вами webhook'ов. Обработчики для подобного рода запросов необходимо реализовать на стороне вашего серверного кода согласно данной спецификации.  Webhook — это подписка на определенный тип события либо их группу, касающихся различных объектов в рамках вашей организации. Для управления webhook'ами используются методы API, описанные в спецификации [Vality Webhook Management API](https://github.com/valitydev/swag-wallets). Когда наступает одно из событий в рамках определенного кошелька (например, изменение статуса кошелька), система выбирает webhook, подходящий под этот тип события, и отправляет HTTP-запрос, содержащий сообщение в формате JSON на указанный в этом webhook'е URL. Если вы создали несколько webhook'ов, подходящих под этот тип события, то событие доставляется одновременно на все заданные в них URL в неопределённом порядке.  ## Стратегия доставки  Система гарантирует порядок доставки событий в рамках определенного предмета оповещения (кошелек, пополнение, выплата и т.п.). Система поддерживает очередь сообщений для каждого предмета оповещения, чтобы соблюсти очередность и гарантированную доставку.  Запрос на доставку считается успешным только при получении ответа со статусом `200`. Система будет ожидать успешного ответа на отправленный запрос в течение 10 секунд. В случае ответа любым другим статусом или по истечении указанного времени, отведённого на обработку оповещения, система будет пытаться повторно доставить оповещения до получения успешного ответа, либо до принятия решения о невозможности доставить информацию. Попытки доставки будут производиться со следующими временными интервалами между запросами:    - 30 секунд,   - 5 минут,   - 15 минут,   - 1 час.   - каждый час в течение суток (24 часа)  Если последняя попытка доставить оповещение оканчивается неудачей, все события, которые накопились в очереди этого кошелька, отбрасываются.  ## Авторизация полученных сообщений  Система подтверждает подлинность оповещений, подписывая сообщения приватным ключом, уникальным для каждого webhook'а, парный публичный ключ к которому содержится в данных этого webhook'а. Подпись передается в HTTP-заголовке `Content-Signature`. В заголовке в виде различных атрибутов содержится информация об использованном при формировании подписи алгоритме и значение подписи в формате [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  На данный момент возможно использование единственного алоритма формирования подписи.  ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3)  Подпись формируется согласно алгоритму [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2), на вход которому подаётся результат вычисления хэша сообщения по алгоритму [SHA-256](https://tools.ietf.org/html/rfc6234).  Набор атрибутов заголовка и список возможных алгоритмов формирования подписи в дальнейшем могут быть расширены. 
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag.wallets.webhook.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.wallets.webhook.events.model.DestinationAuthorized;
import dev.vality.swag.wallets.webhook.events.model.DestinationAuthorizedAllOf;
import dev.vality.swag.wallets.webhook.events.model.DestinationCreated;
import dev.vality.swag.wallets.webhook.events.model.DestinationUnauthorized;
import dev.vality.swag.wallets.webhook.events.model.Event;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalFailed;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalStarted;
import dev.vality.swag.wallets.webhook.events.model.WithdrawalSucceeded;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Смена статуса приемника на не авторизованный
 */
@ApiModel(description = "Смена статуса приемника на не авторизованный")
@JsonPropertyOrder({
  DestinationUnauthorized.JSON_PROPERTY_DESTINATION_I_D,
  DestinationUnauthorized.JSON_PROPERTY_EXTERNAL_I_D
})
@JsonTypeName("DestinationUnauthorized")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-12T19:05:48.700078970Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "eventType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = DestinationAuthorized.class, name = "DestinationAuthorized"),
  @JsonSubTypes.Type(value = DestinationCreated.class, name = "DestinationCreated"),
  @JsonSubTypes.Type(value = DestinationUnauthorized.class, name = "DestinationUnauthorized"),
  @JsonSubTypes.Type(value = WithdrawalFailed.class, name = "WithdrawalFailed"),
  @JsonSubTypes.Type(value = WithdrawalStarted.class, name = "WithdrawalStarted"),
  @JsonSubTypes.Type(value = WithdrawalSucceeded.class, name = "WithdrawalSucceeded"),
})

public class DestinationUnauthorized extends Event {
  public static final String JSON_PROPERTY_DESTINATION_I_D = "destinationID";
  private String destinationID;

  public static final String JSON_PROPERTY_EXTERNAL_I_D = "externalID";
  private String externalID;

  public DestinationUnauthorized() { 
  }

  public DestinationUnauthorized destinationID(String destinationID) {
    
    this.destinationID = destinationID;
    return this;
  }

   /**
   * Идентификатор места назначения денежных средств
   * @return destinationID
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "10ASF74D98", required = true, value = "Идентификатор места назначения денежных средств")
  @JsonProperty(JSON_PROPERTY_DESTINATION_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDestinationID() {
    return destinationID;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestinationID(String destinationID) {
    this.destinationID = destinationID;
  }


  public DestinationUnauthorized externalID(String externalID) {
    
    this.externalID = externalID;
    return this;
  }

   /**
   * Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. 
   * @return externalID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10036274", value = "Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. ")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalID() {
    return externalID;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DestinationUnauthorized destinationUnauthorized = (DestinationUnauthorized) o;
    return Objects.equals(this.destinationID, destinationUnauthorized.destinationID) &&
        Objects.equals(this.externalID, destinationUnauthorized.externalID) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(destinationID, externalID, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DestinationUnauthorized {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    destinationID: ").append(toIndentedString(destinationID)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

