package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * DestinationAuthorizedAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-03-14T17:06:59.238896371Z[Etc/UTC]")
public class DestinationAuthorizedAllOf   {
  @JsonProperty("destinationID")
  private String destinationID;

  @JsonProperty("externalID")
  private String externalID;

  public DestinationAuthorizedAllOf destinationID(String destinationID) {
    this.destinationID = destinationID;
    return this;
  }

  /**
   * Идентификатор места назначения денежных средств
   * @return destinationID
  */
  @ApiModelProperty(example = "10ASF74D98", required = true, value = "Идентификатор места назначения денежных средств")
  @NotNull


  public String getDestinationID() {
    return destinationID;
  }

  public void setDestinationID(String destinationID) {
    this.destinationID = destinationID;
  }

  public DestinationAuthorizedAllOf externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. 
   * @return externalID
  */
  @ApiModelProperty(example = "10036274", value = "Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. ")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DestinationAuthorizedAllOf destinationAuthorizedAllOf = (DestinationAuthorizedAllOf) o;
    return Objects.equals(this.destinationID, destinationAuthorizedAllOf.destinationID) &&
        Objects.equals(this.externalID, destinationAuthorizedAllOf.externalID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(destinationID, externalID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DestinationAuthorizedAllOf {\n");
    
    sb.append("    destinationID: ").append(toIndentedString(destinationID)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

