package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.wallets.webhook.events.model.CryptoCurrency;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * CryptoWalletAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-03-14T17:06:59.238896371Z[Etc/UTC]")
public class CryptoWalletAllOf   {
  @JsonProperty("cryptoWalletId")
  private String cryptoWalletId;

  @JsonProperty("currency")
  private CryptoCurrency currency;

  public CryptoWalletAllOf cryptoWalletId(String cryptoWalletId) {
    this.cryptoWalletId = cryptoWalletId;
    return this;
  }

  /**
   * Идентификатор (он же адрес) криптовалютного кошелька
   * @return cryptoWalletId
  */
  @ApiModelProperty(example = "zu3TcwGI71Bpaaw2XkLWZXlhMdn4zpVzMQ", required = true, value = "Идентификатор (он же адрес) криптовалютного кошелька")
  @NotNull

@Size(min = 16, max = 256) 
  public String getCryptoWalletId() {
    return cryptoWalletId;
  }

  public void setCryptoWalletId(String cryptoWalletId) {
    this.cryptoWalletId = cryptoWalletId;
  }

  public CryptoWalletAllOf currency(CryptoCurrency currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public CryptoCurrency getCurrency() {
    return currency;
  }

  public void setCurrency(CryptoCurrency currency) {
    this.currency = currency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoWalletAllOf cryptoWalletAllOf = (CryptoWalletAllOf) o;
    return Objects.equals(this.cryptoWalletId, cryptoWalletAllOf.cryptoWalletId) &&
        Objects.equals(this.currency, cryptoWalletAllOf.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cryptoWalletId, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoWalletAllOf {\n");
    
    sb.append("    cryptoWalletId: ").append(toIndentedString(cryptoWalletId)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

