/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.wallets.webhook.events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag.wallets.webhook.events.model.DestinationResource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@ApiModel(description="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432")
public class Destination {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="identity")
    private String identity;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="resource")
    private DestinationResource resource;
    @JsonProperty(value="metadata")
    private Object metadata;
    @JsonProperty(value="externalID")
    private String externalID;

    public Destination id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="10ASF74D98", value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0435\u0441\u0442\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Destination name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Squarey plastic thingy", required=true, value="\u0427\u0435\u043b\u043e\u0432\u0435\u043a\u043e\u0447\u0438\u0442\u0430\u0435\u043c\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0438\u0451\u043c\u043d\u0438\u043a\u0430 \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u043f\u043e \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u0435\u0433\u043e \u043b\u0435\u0433\u043a\u043e \u0443\u0437\u043d\u0430\u0442\u044c ")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Destination identity(String identity) {
        this.identity = identity;
        return this;
    }

    @ApiModelProperty(example="tZ0jUmlsV0", required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430")
    @NotNull
    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public Destination currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(example="RUB", required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public @NotNull @Pattern(regexp="^[A-Z]{3}$") String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Destination resource(DestinationResource resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public DestinationResource getResource() {
        return this.resource;
    }

    public void setResource(DestinationResource resource) {
        this.resource = resource;
    }

    public Destination metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="{\"color_hint\":\"olive-green\"}", value="\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439, \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u0447\u043d\u044b\u0439 \u0434\u043b\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 API \u0438 \u043d\u0435\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u044b\u0439 \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043d\u0430\u0431\u043e\u0440 \u0434\u0430\u043d\u043d\u044b\u0445, \u0430\u0441\u0441\u043e\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u043f\u0440\u0438\u0451\u043c\u043d\u0438\u043a\u043e\u043c ")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Destination externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @ApiModelProperty(example="10036274", value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 \u043d\u0430 \u0432\u0430\u0448\u0435\u0439 \u0441\u0442\u043e\u0440\u043e\u043d\u0435.  \u041f\u0440\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u0434\u043b\u044f \u0442\u043e\u0433\u043e, \u0447\u0442\u043e\u0431\u044b \u0433\u0430\u0440\u0430\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0434\u0435\u043c\u043f\u043e\u0442\u0435\u043d\u0442\u043d\u0443\u044e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438. ")
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination destination = (Destination)o;
        return Objects.equals(this.id, destination.id) && Objects.equals(this.name, destination.name) && Objects.equals(this.identity, destination.identity) && Objects.equals(this.currency, destination.currency) && Objects.equals(this.resource, destination.resource) && Objects.equals(this.metadata, destination.metadata) && Objects.equals(this.externalID, destination.externalID);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.identity, this.currency, this.resource, this.metadata, this.externalID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Destination {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

