package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.wallets.webhook.events.model.Asset;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import org.openapitools.jackson.nullable.JsonNullable;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Данные вывода денежных средств
 */
@ApiModel(description = "Данные вывода денежных средств")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-03-03T13:21:56.718207632Z[Etc/UTC]")
public class Withdrawal   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("destination")
  private String destination;

  @JsonProperty("body")
  private Asset body;

  @JsonProperty("metadata")
  private JsonNullable<Object> metadata = JsonNullable.undefined();

  @JsonProperty("wallet")
  private String wallet;

  @JsonProperty("externalID")
  private String externalID;

  public Withdrawal id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор вывода денежных средств
   * @return id
  */
  @ApiModelProperty(example = "tZ0jUmlsV0", value = "Идентификатор вывода денежных средств")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Withdrawal createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время запуска вывода
   * @return createdAt
  */
  @ApiModelProperty(value = "Дата и время запуска вывода")

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Withdrawal destination(String destination) {
    this.destination = destination;
    return this;
  }

  /**
   * Идентификатор места назначения денежных средств
   * @return destination
  */
  @ApiModelProperty(example = "10ASF74D98", required = true, value = "Идентификатор места назначения денежных средств")
  @NotNull


  public String getDestination() {
    return destination;
  }

  public void setDestination(String destination) {
    this.destination = destination;
  }

  public Withdrawal body(Asset body) {
    this.body = body;
    return this;
  }

  /**
   * Get body
   * @return body
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Asset getBody() {
    return body;
  }

  public void setBody(Asset body) {
    this.body = body;
  }

  public Withdrawal metadata(Object metadata) {
    this.metadata = JsonNullable.of(metadata);
    return this;
  }

  /**
   * Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данным выводом 
   * @return metadata
  */
  @ApiModelProperty(value = "Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данным выводом ")


  public JsonNullable<Object> getMetadata() {
    return metadata;
  }

  public void setMetadata(JsonNullable<Object> metadata) {
    this.metadata = metadata;
  }

  public Withdrawal wallet(String wallet) {
    this.wallet = wallet;
    return this;
  }

  /**
   * Идентификатор кошелька
   * @return wallet
  */
  @ApiModelProperty(example = "10068321", required = true, value = "Идентификатор кошелька")
  @NotNull


  public String getWallet() {
    return wallet;
  }

  public void setWallet(String wallet) {
    this.wallet = wallet;
  }

  public Withdrawal externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. 
   * @return externalID
  */
  @ApiModelProperty(example = "10036274", value = "Уникальный идентификатор сущности на вашей стороне.  При указании будет использован для того, чтобы гарантировать идемпотентную обработку операции. ")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Withdrawal withdrawal = (Withdrawal) o;
    return Objects.equals(this.id, withdrawal.id) &&
        Objects.equals(this.createdAt, withdrawal.createdAt) &&
        Objects.equals(this.destination, withdrawal.destination) &&
        Objects.equals(this.body, withdrawal.body) &&
        Objects.equals(this.metadata, withdrawal.metadata) &&
        Objects.equals(this.wallet, withdrawal.wallet) &&
        Objects.equals(this.externalID, withdrawal.externalID);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, destination, body, metadata, wallet, externalID);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Withdrawal {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    wallet: ").append(toIndentedString(wallet)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

