package dev.vality.swag.wallets.webhook.events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * DigitalWalletAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-03-03T13:21:56.718207632Z[Etc/UTC]")
public class DigitalWalletAllOf   {
  @JsonProperty("digitalWalletId")
  private String digitalWalletId;

  @JsonProperty("digitalWalletProvider")
  private String digitalWalletProvider;

  public DigitalWalletAllOf digitalWalletId(String digitalWalletId) {
    this.digitalWalletId = digitalWalletId;
    return this;
  }

  /**
   * Идентификатор кошелька
   * @return digitalWalletId
  */
  @ApiModelProperty(example = "zu3TcwGI71Bpaaw2XkLWZXlhMdn4zpVzMQ", required = true, value = "Идентификатор кошелька")
  @NotNull

@Size(min = 16, max = 256) 
  public String getDigitalWalletId() {
    return digitalWalletId;
  }

  public void setDigitalWalletId(String digitalWalletId) {
    this.digitalWalletId = digitalWalletId;
  }

  public DigitalWalletAllOf digitalWalletProvider(String digitalWalletProvider) {
    this.digitalWalletProvider = digitalWalletProvider;
    return this;
  }

  /**
   * Провайдер электронных денежных средств
   * @return digitalWalletProvider
  */
  @ApiModelProperty(example = "Paypal", required = true, value = "Провайдер электронных денежных средств")
  @NotNull


  public String getDigitalWalletProvider() {
    return digitalWalletProvider;
  }

  public void setDigitalWalletProvider(String digitalWalletProvider) {
    this.digitalWalletProvider = digitalWalletProvider;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DigitalWalletAllOf digitalWalletAllOf = (DigitalWalletAllOf) o;
    return Objects.equals(this.digitalWalletId, digitalWalletAllOf.digitalWalletId) &&
        Objects.equals(this.digitalWalletProvider, digitalWalletAllOf.digitalWalletProvider);
  }

  @Override
  public int hashCode() {
    return Objects.hash(digitalWalletId, digitalWalletProvider);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DigitalWalletAllOf {\n");
    
    sb.append("    digitalWalletId: ").append(toIndentedString(digitalWalletId)).append("\n");
    sb.append("    digitalWalletProvider: ").append(toIndentedString(digitalWalletProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

