/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.messages.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.vality.swag.messages.model.ConversationParam;
import dev.vality.swag.messages.model.ConversationResponse;
import dev.vality.swag.messages.model.ConversationStatus;
import dev.vality.swag.messages.model.GeneralError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="conversation", description="the conversation API")
public interface ConversationApi {
    public static final Logger log = LoggerFactory.getLogger(ConversationApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="", nickname="getConversations", notes="", response=ConversationResponse.class, authorizations={@Authorization(value="APIKey")}, tags={"Conversations"})
    @ApiResponses(value={@ApiResponse(code=200, message="ConversationResponse", response=ConversationResponse.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b", response=GeneralError.class)})
    @RequestMapping(value={"/conversation"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<ConversationResponse> getConversations(@NotNull @ApiParam(value="", required=true) @Valid @RequestParam(value="conversationId", required=true) List<String> conversationId, @ApiParam(value="") @Valid @RequestParam(value="conversationStatus", required=false) ConversationStatus conversationStatus) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((ConversationResponse)this.getObjectMapper().get().readValue("{\n  \"conversations\" : [ {\n    \"conversationId\" : \"conversationId\",\n    \"messages\" : [ {\n      \"messageId\" : \"messageId\",\n      \"text\" : \"text\",\n      \"userId\" : \"userId\",\n      \"timestamp\" : \"timestamp\"\n    }, {\n      \"messageId\" : \"messageId\",\n      \"text\" : \"text\",\n      \"userId\" : \"userId\",\n      \"timestamp\" : \"timestamp\"\n    } ],\n    \"status\" : \"Actual\"\n  }, {\n    \"conversationId\" : \"conversationId\",\n    \"messages\" : [ {\n      \"messageId\" : \"messageId\",\n      \"text\" : \"text\",\n      \"userId\" : \"userId\",\n      \"timestamp\" : \"timestamp\"\n    }, {\n      \"messageId\" : \"messageId\",\n      \"text\" : \"text\",\n      \"userId\" : \"userId\",\n      \"timestamp\" : \"timestamp\"\n    } ],\n    \"status\" : \"Actual\"\n  } ],\n  \"users\" : {\n    \"key\" : {\n      \"user\" : {\n        \"fullName\" : \"fullName\",\n        \"email\" : \"email\"\n      }\n    }\n  }\n}", ConversationResponse.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConversationApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="saveConversations", notes="", authorizations={@Authorization(value="APIKey")}, tags={"Conversations"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b"), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438")})
    @RequestMapping(value={"/conversation"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<Void> saveConversations(@ApiParam(value="", required=true) @Valid @RequestBody List<ConversationParam> body) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConversationApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

