/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.messages.api;

import dev.vality.swag.messages.ApiClient;
import dev.vality.swag.messages.model.ConversationParam;
import dev.vality.swag.messages.model.ConversationResponse;
import dev.vality.swag.messages.model.ConversationStatus;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="dev.vality.swag.messages.api.ConversationsApi")
public class ConversationsApi {
    private ApiClient apiClient;

    public ConversationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ConversationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ConversationResponse getConversations(List<String> conversationId, ConversationStatus conversationStatus) throws RestClientException {
        Object postBody = null;
        if (conversationId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'conversationId' when calling getConversations");
        }
        String path = UriComponentsBuilder.fromPath((String)"/conversation").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase()), "conversationId", conversationId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "conversationStatus", (Object)conversationStatus));
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"APIKey"};
        ParameterizedTypeReference<ConversationResponse> returnType = new ParameterizedTypeReference<ConversationResponse>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public void saveConversations(List<ConversationParam> body) throws RestClientException {
        List<ConversationParam> postBody = body;
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling saveConversations");
        }
        String path = UriComponentsBuilder.fromPath((String)"/conversation").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] accepts = new String[]{};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"APIKey"};
        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>(){};
        this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

