package dev.vality.swag.messages.api;

import dev.vality.swag.messages.ApiClient;

import dev.vality.swag.messages.model.ConversationParam;
import dev.vality.swag.messages.model.ConversationResponse;
import dev.vality.swag.messages.model.ConversationStatus;
import dev.vality.swag.messages.model.GeneralError;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2022-03-18T10:04:07.174505650Z[Etc/UTC]")@Component("dev.vality.swag.messages.api.ConversationsApi")
public class ConversationsApi {
    private ApiClient apiClient;

    public ConversationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ConversationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * 
     * <p><b>200</b> - ConversationResponse
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Комментарии не найдены
     * @param conversationId The conversationId parameter
     * @param conversationStatus The conversationStatus parameter
     * @return ConversationResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ConversationResponse getConversations(List<String> conversationId, ConversationStatus conversationStatus) throws RestClientException {
        Object postBody = null;
        // verify the required parameter 'conversationId' is set
        if (conversationId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'conversationId' when calling getConversations");
        }
        String path = UriComponentsBuilder.fromPath("/conversation").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase()), "conversationId", conversationId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "conversationStatus", conversationStatus));

        final String[] accepts = { 
            "application/json"
         };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = {  };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "APIKey" };

        ParameterizedTypeReference<ConversationResponse> returnType = new ParameterizedTypeReference<ConversationResponse>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * 
     * <p><b>200</b> - Комментарии сохранены
     * <p><b>401</b> - Ошибка авторизации
     * @param body The body parameter
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void saveConversations(List<ConversationParam> body) throws RestClientException {
        Object postBody = body;
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling saveConversations");
        }
        String path = UriComponentsBuilder.fromPath("/conversation").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] accepts = {  };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json"
         };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "APIKey" };

        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>() {};
        apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}
