/*
 * Decompiled with CFR 0.152.
 */
package com.rbkmoney.swag.dark_api.api;

import com.rbkmoney.swag.dark_api.ApiClient;
import com.rbkmoney.swag.dark_api.model.FileData;
import com.rbkmoney.swag.dark_api.model.FileDownload;
import com.rbkmoney.swag.dark_api.model.FileUploadData;
import com.rbkmoney.swag.dark_api.model.FileUploadRequest;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.rbkmoney.swag.dark_api.api.FilesApi")
public class FilesApi {
    private ApiClient apiClient;

    public FilesApi() {
        this(new ApiClient());
    }

    @Autowired
    public FilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FileDownload downloadFile(String xRequestID, String fileID) throws RestClientException {
        Object postBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling downloadFile");
        }
        if (fileID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fileID' when calling downloadFile");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("fileID", fileID);
        String path = UriComponentsBuilder.fromPath((String)"/files/{fileID}/download").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (xRequestID != null) {
            headerParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        String[] accepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json; charset=utf-8"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"bearer"};
        ParameterizedTypeReference<FileDownload> returnType = new ParameterizedTypeReference<FileDownload>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public FileData getFileInfo(String xRequestID, String fileID) throws RestClientException {
        Object postBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getFileInfo");
        }
        if (fileID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fileID' when calling getFileInfo");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("fileID", fileID);
        String path = UriComponentsBuilder.fromPath((String)"/files/{fileID}/info").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (xRequestID != null) {
            headerParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        String[] accepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json; charset=utf-8"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"bearer"};
        ParameterizedTypeReference<FileData> returnType = new ParameterizedTypeReference<FileData>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public FileUploadData uploadFile(String xRequestID, FileUploadRequest uploadFileRequest) throws RestClientException {
        FileUploadRequest postBody = uploadFileRequest;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling uploadFile");
        }
        String path = UriComponentsBuilder.fromPath((String)"/files/upload").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (xRequestID != null) {
            headerParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        String[] accepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json; charset=utf-8"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"bearer"};
        ParameterizedTypeReference<FileUploadData> returnType = new ParameterizedTypeReference<FileUploadData>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

