/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rbkmoney.swag.dark_api.model.ContactInfo;
import com.rbkmoney.swag.dark_api.model.PersonAnthroponym;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Одноразовое платежное средство
 */
@ApiModel(description = "Одноразовое платежное средство")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class RussianPrivateEntity {
  @JsonProperty("person_anthroponym")
  private PersonAnthroponym personAnthroponym = null;

  @JsonProperty("birth_date")
  private String birthDate = null;

  @JsonProperty("birth_place")
  private String birthPlace = null;

  @JsonProperty("citizenship")
  private String citizenship = null;

  @JsonProperty("residence_address")
  private String residenceAddress = null;

  @JsonProperty("actual_address")
  private String actualAddress = null;

  @JsonProperty("contact_info")
  private ContactInfo contactInfo = null;

  public RussianPrivateEntity personAnthroponym(PersonAnthroponym personAnthroponym) {
    this.personAnthroponym = personAnthroponym;
    return this;
  }

   /**
   * ФИО
   * @return personAnthroponym
  **/
  @ApiModelProperty(value = "ФИО")
  public PersonAnthroponym getPersonAnthroponym() {
    return personAnthroponym;
  }

  public void setPersonAnthroponym(PersonAnthroponym personAnthroponym) {
    this.personAnthroponym = personAnthroponym;
  }

  public RussianPrivateEntity birthDate(String birthDate) {
    this.birthDate = birthDate;
    return this;
  }

   /**
   * Дата рождения
   * @return birthDate
  **/
  @ApiModelProperty(value = "Дата рождения")
  public String getBirthDate() {
    return birthDate;
  }

  public void setBirthDate(String birthDate) {
    this.birthDate = birthDate;
  }

  public RussianPrivateEntity birthPlace(String birthPlace) {
    this.birthPlace = birthPlace;
    return this;
  }

   /**
   * Место рождения
   * @return birthPlace
  **/
  @ApiModelProperty(value = "Место рождения")
  public String getBirthPlace() {
    return birthPlace;
  }

  public void setBirthPlace(String birthPlace) {
    this.birthPlace = birthPlace;
  }

  public RussianPrivateEntity citizenship(String citizenship) {
    this.citizenship = citizenship;
    return this;
  }

   /**
   * Гражданство
   * @return citizenship
  **/
  @ApiModelProperty(value = "Гражданство")
  public String getCitizenship() {
    return citizenship;
  }

  public void setCitizenship(String citizenship) {
    this.citizenship = citizenship;
  }

  public RussianPrivateEntity residenceAddress(String residenceAddress) {
    this.residenceAddress = residenceAddress;
    return this;
  }

   /**
   * Адрес места жительства
   * @return residenceAddress
  **/
  @ApiModelProperty(value = "Адрес места жительства")
  public String getResidenceAddress() {
    return residenceAddress;
  }

  public void setResidenceAddress(String residenceAddress) {
    this.residenceAddress = residenceAddress;
  }

  public RussianPrivateEntity actualAddress(String actualAddress) {
    this.actualAddress = actualAddress;
    return this;
  }

   /**
   * Фактический адрес
   * @return actualAddress
  **/
  @ApiModelProperty(value = "Фактический адрес")
  public String getActualAddress() {
    return actualAddress;
  }

  public void setActualAddress(String actualAddress) {
    this.actualAddress = actualAddress;
  }

  public RussianPrivateEntity contactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
    return this;
  }

   /**
   * Контактная информация
   * @return contactInfo
  **/
  @ApiModelProperty(value = "Контактная информация")
  public ContactInfo getContactInfo() {
    return contactInfo;
  }

  public void setContactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RussianPrivateEntity russianPrivateEntity = (RussianPrivateEntity) o;
    return Objects.equals(this.personAnthroponym, russianPrivateEntity.personAnthroponym) &&
        Objects.equals(this.birthDate, russianPrivateEntity.birthDate) &&
        Objects.equals(this.birthPlace, russianPrivateEntity.birthPlace) &&
        Objects.equals(this.citizenship, russianPrivateEntity.citizenship) &&
        Objects.equals(this.residenceAddress, russianPrivateEntity.residenceAddress) &&
        Objects.equals(this.actualAddress, russianPrivateEntity.actualAddress) &&
        Objects.equals(this.contactInfo, russianPrivateEntity.contactInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(personAnthroponym, birthDate, birthPlace, citizenship, residenceAddress, actualAddress, contactInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RussianPrivateEntity {\n");
    
    sb.append("    personAnthroponym: ").append(toIndentedString(personAnthroponym)).append("\n");
    sb.append("    birthDate: ").append(toIndentedString(birthDate)).append("\n");
    sb.append("    birthPlace: ").append(toIndentedString(birthPlace)).append("\n");
    sb.append("    citizenship: ").append(toIndentedString(citizenship)).append("\n");
    sb.append("    residenceAddress: ").append(toIndentedString(residenceAddress)).append("\n");
    sb.append("    actualAddress: ").append(toIndentedString(actualAddress)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

