/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rbkmoney.swag.dark_api.model.Activity;
import com.rbkmoney.swag.dark_api.model.AdditionalInfo;
import com.rbkmoney.swag.dark_api.model.BeneficialOwner;
import com.rbkmoney.swag.dark_api.model.FoundersInfo;
import com.rbkmoney.swag.dark_api.model.LegalEntity;
import com.rbkmoney.swag.dark_api.model.LegalOwnerInfo;
import com.rbkmoney.swag.dark_api.model.LicenseInfo;
import com.rbkmoney.swag.dark_api.model.RegistrationInfo;
import com.rbkmoney.swag.dark_api.model.ResidencyInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * Анкета юридического лица, резидент РФ
 */
@ApiModel(description = "Анкета юридического лица, резидент РФ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class RussianLegalEntity extends LegalEntity {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("foreign_name")
  private String foreignName = null;

  @JsonProperty("legal_form")
  private String legalForm = null;

  @JsonProperty("inn")
  private String inn = null;

  @JsonProperty("registration_info")
  private RegistrationInfo registrationInfo = null;

  @JsonProperty("additional_space")
  private String additionalSpace = null;

  @JsonProperty("property_info")
  private List<String> propertyInfo = null;

  @JsonProperty("okato_code")
  private String okatoCode = null;

  @JsonProperty("okpo_code")
  private String okpoCode = null;

  @JsonProperty("postal_address")
  private String postalAddress = null;

  @JsonProperty("founders_info")
  private FoundersInfo foundersInfo = null;

  @JsonProperty("license_info")
  private LicenseInfo licenseInfo = null;

  @JsonProperty("principal_activity")
  private Activity principalActivity = null;

  @JsonProperty("legal_owner_info")
  private LegalOwnerInfo legalOwnerInfo = null;

  @JsonProperty("beneficial_owners")
  private List<BeneficialOwner> beneficialOwners = null;

  @JsonProperty("additional_info")
  private AdditionalInfo additionalInfo = null;

  @JsonProperty("residency_info")
  private ResidencyInfo residencyInfo = null;

  public RussianLegalEntity name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Наименование, фирменное наименование на русском языке
   * @return name
  **/
  @ApiModelProperty(value = "Наименование, фирменное наименование на русском языке")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public RussianLegalEntity foreignName(String foreignName) {
    this.foreignName = foreignName;
    return this;
  }

   /**
   * Наименование, фирменное наименование на иностранном языке
   * @return foreignName
  **/
  @ApiModelProperty(value = "Наименование, фирменное наименование на иностранном языке")
  public String getForeignName() {
    return foreignName;
  }

  public void setForeignName(String foreignName) {
    this.foreignName = foreignName;
  }

  public RussianLegalEntity legalForm(String legalForm) {
    this.legalForm = legalForm;
    return this;
  }

   /**
   * Организационно-правовая форма
   * @return legalForm
  **/
  @ApiModelProperty(value = "Организационно-правовая форма")
  public String getLegalForm() {
    return legalForm;
  }

  public void setLegalForm(String legalForm) {
    this.legalForm = legalForm;
  }

  public RussianLegalEntity inn(String inn) {
    this.inn = inn;
    return this;
  }

   /**
   * ИНН
   * @return inn
  **/
  @ApiModelProperty(value = "ИНН")
  public String getInn() {
    return inn;
  }

  public void setInn(String inn) {
    this.inn = inn;
  }

  public RussianLegalEntity registrationInfo(RegistrationInfo registrationInfo) {
    this.registrationInfo = registrationInfo;
    return this;
  }

   /**
   * Get registrationInfo
   * @return registrationInfo
  **/
  @ApiModelProperty(value = "")
  public RegistrationInfo getRegistrationInfo() {
    return registrationInfo;
  }

  public void setRegistrationInfo(RegistrationInfo registrationInfo) {
    this.registrationInfo = registrationInfo;
  }

  public RussianLegalEntity additionalSpace(String additionalSpace) {
    this.additionalSpace = additionalSpace;
    return this;
  }

   /**
   * Наличие дополнительных площадей
   * @return additionalSpace
  **/
  @ApiModelProperty(value = "Наличие дополнительных площадей")
  public String getAdditionalSpace() {
    return additionalSpace;
  }

  public void setAdditionalSpace(String additionalSpace) {
    this.additionalSpace = additionalSpace;
  }

  public RussianLegalEntity propertyInfo(List<String> propertyInfo) {
    this.propertyInfo = propertyInfo;
    return this;
  }

  public RussianLegalEntity addPropertyInfoItem(String propertyInfoItem) {
    if (this.propertyInfo == null) {
      this.propertyInfo = new ArrayList<>();
    }
    this.propertyInfo.add(propertyInfoItem);
    return this;
  }

   /**
   * Get propertyInfo
   * @return propertyInfo
  **/
  @ApiModelProperty(value = "")
  public List<String> getPropertyInfo() {
    return propertyInfo;
  }

  public void setPropertyInfo(List<String> propertyInfo) {
    this.propertyInfo = propertyInfo;
  }

  public RussianLegalEntity okatoCode(String okatoCode) {
    this.okatoCode = okatoCode;
    return this;
  }

   /**
   * код в соответствии с ОКАТО
   * @return okatoCode
  **/
  @ApiModelProperty(value = "код в соответствии с ОКАТО")
  public String getOkatoCode() {
    return okatoCode;
  }

  public void setOkatoCode(String okatoCode) {
    this.okatoCode = okatoCode;
  }

  public RussianLegalEntity okpoCode(String okpoCode) {
    this.okpoCode = okpoCode;
    return this;
  }

   /**
   * код в соответствии с ОКПО
   * @return okpoCode
  **/
  @ApiModelProperty(value = "код в соответствии с ОКПО")
  public String getOkpoCode() {
    return okpoCode;
  }

  public void setOkpoCode(String okpoCode) {
    this.okpoCode = okpoCode;
  }

  public RussianLegalEntity postalAddress(String postalAddress) {
    this.postalAddress = postalAddress;
    return this;
  }

   /**
   * Get postalAddress
   * @return postalAddress
  **/
  @ApiModelProperty(value = "")
  public String getPostalAddress() {
    return postalAddress;
  }

  public void setPostalAddress(String postalAddress) {
    this.postalAddress = postalAddress;
  }

  public RussianLegalEntity foundersInfo(FoundersInfo foundersInfo) {
    this.foundersInfo = foundersInfo;
    return this;
  }

   /**
   * Get foundersInfo
   * @return foundersInfo
  **/
  @ApiModelProperty(value = "")
  public FoundersInfo getFoundersInfo() {
    return foundersInfo;
  }

  public void setFoundersInfo(FoundersInfo foundersInfo) {
    this.foundersInfo = foundersInfo;
  }

  public RussianLegalEntity licenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * Get licenseInfo
   * @return licenseInfo
  **/
  @ApiModelProperty(value = "")
  public LicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }

  public RussianLegalEntity principalActivity(Activity principalActivity) {
    this.principalActivity = principalActivity;
    return this;
  }

   /**
   * Get principalActivity
   * @return principalActivity
  **/
  @ApiModelProperty(value = "")
  public Activity getPrincipalActivity() {
    return principalActivity;
  }

  public void setPrincipalActivity(Activity principalActivity) {
    this.principalActivity = principalActivity;
  }

  public RussianLegalEntity legalOwnerInfo(LegalOwnerInfo legalOwnerInfo) {
    this.legalOwnerInfo = legalOwnerInfo;
    return this;
  }

   /**
   * Get legalOwnerInfo
   * @return legalOwnerInfo
  **/
  @ApiModelProperty(value = "")
  public LegalOwnerInfo getLegalOwnerInfo() {
    return legalOwnerInfo;
  }

  public void setLegalOwnerInfo(LegalOwnerInfo legalOwnerInfo) {
    this.legalOwnerInfo = legalOwnerInfo;
  }

  public RussianLegalEntity beneficialOwners(List<BeneficialOwner> beneficialOwners) {
    this.beneficialOwners = beneficialOwners;
    return this;
  }

  public RussianLegalEntity addBeneficialOwnersItem(BeneficialOwner beneficialOwnersItem) {
    if (this.beneficialOwners == null) {
      this.beneficialOwners = new ArrayList<>();
    }
    this.beneficialOwners.add(beneficialOwnersItem);
    return this;
  }

   /**
   * Get beneficialOwners
   * @return beneficialOwners
  **/
  @ApiModelProperty(value = "")
  public List<BeneficialOwner> getBeneficialOwners() {
    return beneficialOwners;
  }

  public void setBeneficialOwners(List<BeneficialOwner> beneficialOwners) {
    this.beneficialOwners = beneficialOwners;
  }

  public RussianLegalEntity additionalInfo(AdditionalInfo additionalInfo) {
    this.additionalInfo = additionalInfo;
    return this;
  }

   /**
   * Get additionalInfo
   * @return additionalInfo
  **/
  @ApiModelProperty(value = "")
  public AdditionalInfo getAdditionalInfo() {
    return additionalInfo;
  }

  public void setAdditionalInfo(AdditionalInfo additionalInfo) {
    this.additionalInfo = additionalInfo;
  }

  public RussianLegalEntity residencyInfo(ResidencyInfo residencyInfo) {
    this.residencyInfo = residencyInfo;
    return this;
  }

   /**
   * Get residencyInfo
   * @return residencyInfo
  **/
  @ApiModelProperty(value = "")
  public ResidencyInfo getResidencyInfo() {
    return residencyInfo;
  }

  public void setResidencyInfo(ResidencyInfo residencyInfo) {
    this.residencyInfo = residencyInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RussianLegalEntity russianLegalEntity = (RussianLegalEntity) o;
    return Objects.equals(this.name, russianLegalEntity.name) &&
        Objects.equals(this.foreignName, russianLegalEntity.foreignName) &&
        Objects.equals(this.legalForm, russianLegalEntity.legalForm) &&
        Objects.equals(this.inn, russianLegalEntity.inn) &&
        Objects.equals(this.registrationInfo, russianLegalEntity.registrationInfo) &&
        Objects.equals(this.additionalSpace, russianLegalEntity.additionalSpace) &&
        Objects.equals(this.propertyInfo, russianLegalEntity.propertyInfo) &&
        Objects.equals(this.okatoCode, russianLegalEntity.okatoCode) &&
        Objects.equals(this.okpoCode, russianLegalEntity.okpoCode) &&
        Objects.equals(this.postalAddress, russianLegalEntity.postalAddress) &&
        Objects.equals(this.foundersInfo, russianLegalEntity.foundersInfo) &&
        Objects.equals(this.licenseInfo, russianLegalEntity.licenseInfo) &&
        Objects.equals(this.principalActivity, russianLegalEntity.principalActivity) &&
        Objects.equals(this.legalOwnerInfo, russianLegalEntity.legalOwnerInfo) &&
        Objects.equals(this.beneficialOwners, russianLegalEntity.beneficialOwners) &&
        Objects.equals(this.additionalInfo, russianLegalEntity.additionalInfo) &&
        Objects.equals(this.residencyInfo, russianLegalEntity.residencyInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, foreignName, legalForm, inn, registrationInfo, additionalSpace, propertyInfo, okatoCode, okpoCode, postalAddress, foundersInfo, licenseInfo, principalActivity, legalOwnerInfo, beneficialOwners, additionalInfo, residencyInfo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RussianLegalEntity {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    foreignName: ").append(toIndentedString(foreignName)).append("\n");
    sb.append("    legalForm: ").append(toIndentedString(legalForm)).append("\n");
    sb.append("    inn: ").append(toIndentedString(inn)).append("\n");
    sb.append("    registrationInfo: ").append(toIndentedString(registrationInfo)).append("\n");
    sb.append("    additionalSpace: ").append(toIndentedString(additionalSpace)).append("\n");
    sb.append("    propertyInfo: ").append(toIndentedString(propertyInfo)).append("\n");
    sb.append("    okatoCode: ").append(toIndentedString(okatoCode)).append("\n");
    sb.append("    okpoCode: ").append(toIndentedString(okpoCode)).append("\n");
    sb.append("    postalAddress: ").append(toIndentedString(postalAddress)).append("\n");
    sb.append("    foundersInfo: ").append(toIndentedString(foundersInfo)).append("\n");
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("    principalActivity: ").append(toIndentedString(principalActivity)).append("\n");
    sb.append("    legalOwnerInfo: ").append(toIndentedString(legalOwnerInfo)).append("\n");
    sb.append("    beneficialOwners: ").append(toIndentedString(beneficialOwners)).append("\n");
    sb.append("    additionalInfo: ").append(toIndentedString(additionalInfo)).append("\n");
    sb.append("    residencyInfo: ").append(toIndentedString(residencyInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

