/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Сведения о документе подтверждающем право пребывания в РФ
 */
@ApiModel(description = "Сведения о документе подтверждающем право пребывания в РФ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class ResidenceApprove {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("series")
  private String series = null;

  @JsonProperty("number")
  private String number = null;

  @JsonProperty("beginning_date")
  private String beginningDate = null;

  @JsonProperty("expiration_date")
  private String expirationDate = null;

  public ResidenceApprove name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Наименования документа
   * @return name
  **/
  @ApiModelProperty(value = "Наименования документа")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ResidenceApprove series(String series) {
    this.series = series;
    return this;
  }

   /**
   * Get series
   * @return series
  **/
  @ApiModelProperty(value = "")
  public String getSeries() {
    return series;
  }

  public void setSeries(String series) {
    this.series = series;
  }

  public ResidenceApprove number(String number) {
    this.number = number;
    return this;
  }

   /**
   * Get number
   * @return number
  **/
  @ApiModelProperty(value = "")
  public String getNumber() {
    return number;
  }

  public void setNumber(String number) {
    this.number = number;
  }

  public ResidenceApprove beginningDate(String beginningDate) {
    this.beginningDate = beginningDate;
    return this;
  }

   /**
   * Дата начала срока действия права пребывания (проживания)
   * @return beginningDate
  **/
  @ApiModelProperty(value = "Дата начала срока действия права пребывания (проживания)")
  public String getBeginningDate() {
    return beginningDate;
  }

  public void setBeginningDate(String beginningDate) {
    this.beginningDate = beginningDate;
  }

  public ResidenceApprove expirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
    return this;
  }

   /**
   * Дата окончания срока действия права пребывания (проживания)
   * @return expirationDate
  **/
  @ApiModelProperty(value = "Дата окончания срока действия права пребывания (проживания)")
  public String getExpirationDate() {
    return expirationDate;
  }

  public void setExpirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResidenceApprove residenceApprove = (ResidenceApprove) o;
    return Objects.equals(this.name, residenceApprove.name) &&
        Objects.equals(this.series, residenceApprove.series) &&
        Objects.equals(this.number, residenceApprove.number) &&
        Objects.equals(this.beginningDate, residenceApprove.beginningDate) &&
        Objects.equals(this.expirationDate, residenceApprove.expirationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, series, number, beginningDate, expirationDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResidenceApprove {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    beginningDate: ").append(toIndentedString(beginningDate)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

