/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rbkmoney.swag.dark_api.model.InvoiceLine;
import com.rbkmoney.swag.dark_api.model.Refund;
import com.rbkmoney.swag.dark_api.model.RefundError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * RefundSearchResult
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class RefundSearchResult {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("amount")
  private Long amount = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonProperty("cart")
  private List<InvoiceLine> cart = null;

  /**
   * Статус возврата
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    SUCCEEDED("succeeded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("error")
  private RefundError error = null;

  @JsonProperty("invoiceID")
  private String invoiceID = null;

  @JsonProperty("paymentID")
  private String paymentID = null;

  public RefundSearchResult id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Идентификатор возврата
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор возврата")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public RefundSearchResult createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Дата и время осуществления
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время осуществления")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public RefundSearchResult amount(Long amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Сумма возврата, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "Сумма возврата, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public RefundSearchResult currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public RefundSearchResult reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Причина осуществления возврата
   * @return reason
  **/
  @ApiModelProperty(value = "Причина осуществления возврата")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public RefundSearchResult cart(List<InvoiceLine> cart) {
    this.cart = cart;
    return this;
  }

  public RefundSearchResult addCartItem(InvoiceLine cartItem) {
    if (this.cart == null) {
      this.cart = new ArrayList<>();
    }
    this.cart.add(cartItem);
    return this;
  }

   /**
   * Итоговая корзина предоставляемых товаров и услуг, которая должна формироваться из корзины инвойса исключением позиций, по которым производился возврат. Сумма корзины должна совпадать с суммой платежа за вычетом суммы возврата. 
   * @return cart
  **/
  @ApiModelProperty(value = "Итоговая корзина предоставляемых товаров и услуг, которая должна формироваться из корзины инвойса исключением позиций, по которым производился возврат. Сумма корзины должна совпадать с суммой платежа за вычетом суммы возврата. ")
  public List<InvoiceLine> getCart() {
    return cart;
  }

  public void setCart(List<InvoiceLine> cart) {
    this.cart = cart;
  }

  public RefundSearchResult status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Статус возврата
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Статус возврата")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public RefundSearchResult error(RefundError error) {
    this.error = error;
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @ApiModelProperty(value = "")
  public RefundError getError() {
    return error;
  }

  public void setError(RefundError error) {
    this.error = error;
  }

  public RefundSearchResult invoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
    return this;
  }

   /**
   * Идентификатор инвойса
   * @return invoiceID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  public String getInvoiceID() {
    return invoiceID;
  }

  public void setInvoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
  }

  public RefundSearchResult paymentID(String paymentID) {
    this.paymentID = paymentID;
    return this;
  }

   /**
   * Идентификатор платежа
   * @return paymentID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  public String getPaymentID() {
    return paymentID;
  }

  public void setPaymentID(String paymentID) {
    this.paymentID = paymentID;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundSearchResult refundSearchResult = (RefundSearchResult) o;
    return Objects.equals(this.id, refundSearchResult.id) &&
        Objects.equals(this.createdAt, refundSearchResult.createdAt) &&
        Objects.equals(this.amount, refundSearchResult.amount) &&
        Objects.equals(this.currency, refundSearchResult.currency) &&
        Objects.equals(this.reason, refundSearchResult.reason) &&
        Objects.equals(this.cart, refundSearchResult.cart) &&
        Objects.equals(this.status, refundSearchResult.status) &&
        Objects.equals(this.error, refundSearchResult.error) &&
        Objects.equals(this.invoiceID, refundSearchResult.invoiceID) &&
        Objects.equals(this.paymentID, refundSearchResult.paymentID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, amount, currency, reason, cart, status, error, invoiceID, paymentID);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundSearchResult {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    invoiceID: ").append(toIndentedString(invoiceID)).append("\n");
    sb.append("    paymentID: ").append(toIndentedString(paymentID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

