/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rbkmoney.swag.dark_api.model.GeoLocationInfo;
import com.rbkmoney.swag.dark_api.model.InvoiceCart;
import com.rbkmoney.swag.dark_api.model.Payer;
import com.rbkmoney.swag.dark_api.model.PaymentError;
import com.rbkmoney.swag.dark_api.model.PaymentFlow;
import com.rbkmoney.swag.dark_api.model.PaymentStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;

/**
 * PaymentSearchResult
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class PaymentSearchResult {
  /**
   * Статус платежа
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    PROCESSED("processed"),
    
    CAPTURED("captured"),
    
    CANCELLED("cancelled"),
    
    REFUNDED("refunded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("error")
  private PaymentError error = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("shortID")
  private String shortID = null;

  @JsonProperty("invoiceID")
  private String invoiceID = null;

  @JsonProperty("shopID")
  private String shopID = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("amount")
  private Long amount = null;

  @JsonProperty("fee")
  private Long fee = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("payer")
  private Payer payer = null;

  @JsonProperty("flow")
  private PaymentFlow flow = null;

  @JsonProperty("geoLocationInfo")
  private GeoLocationInfo geoLocationInfo = null;

  @JsonProperty("metadata")
  private Object metadata = null;

  @JsonProperty("invoiceMetadata")
  private Object invoiceMetadata = null;

  @JsonProperty("statusChangedAt")
  private OffsetDateTime statusChangedAt = null;

  @JsonProperty("makeRecurrent")
  private Boolean makeRecurrent = false;

  @JsonProperty("cart")
  private InvoiceCart cart = null;

  public PaymentSearchResult status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Статус платежа
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Статус платежа")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public PaymentSearchResult error(PaymentError error) {
    this.error = error;
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @ApiModelProperty(value = "")
  public PaymentError getError() {
    return error;
  }

  public void setError(PaymentError error) {
    this.error = error;
  }

  public PaymentSearchResult id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Идентификатор платежа
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public PaymentSearchResult shortID(String shortID) {
    this.shortID = shortID;
    return this;
  }

   /**
   * Cокращенный идентификатор платежа и инвойса (spid)
   * @return shortID
  **/
  @ApiModelProperty(value = "Cокращенный идентификатор платежа и инвойса (spid)")
  public String getShortID() {
    return shortID;
  }

  public void setShortID(String shortID) {
    this.shortID = shortID;
  }

  public PaymentSearchResult invoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
    return this;
  }

   /**
   * Идентификатор инвойса, в рамках которого был создан платеж
   * @return invoiceID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор инвойса, в рамках которого был создан платеж")
  public String getInvoiceID() {
    return invoiceID;
  }

  public void setInvoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
  }

  public PaymentSearchResult shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

   /**
   * Идентификатор магазина, в рамках которого был создан платеж
   * @return shopID
  **/
  @ApiModelProperty(value = "Идентификатор магазина, в рамках которого был создан платеж")
  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public PaymentSearchResult createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Дата и время создания
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время создания")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public PaymentSearchResult amount(Long amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public PaymentSearchResult fee(Long fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Комиссия системы, в минорных денежных единицах
   * minimum: 0
   * @return fee
  **/
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах")
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public PaymentSearchResult currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public PaymentSearchResult payer(Payer payer) {
    this.payer = payer;
    return this;
  }

   /**
   * Get payer
   * @return payer
  **/
  @ApiModelProperty(required = true, value = "")
  public Payer getPayer() {
    return payer;
  }

  public void setPayer(Payer payer) {
    this.payer = payer;
  }

  public PaymentSearchResult flow(PaymentFlow flow) {
    this.flow = flow;
    return this;
  }

   /**
   * Get flow
   * @return flow
  **/
  @ApiModelProperty(required = true, value = "")
  public PaymentFlow getFlow() {
    return flow;
  }

  public void setFlow(PaymentFlow flow) {
    this.flow = flow;
  }

  public PaymentSearchResult geoLocationInfo(GeoLocationInfo geoLocationInfo) {
    this.geoLocationInfo = geoLocationInfo;
    return this;
  }

   /**
   * Get geoLocationInfo
   * @return geoLocationInfo
  **/
  @ApiModelProperty(value = "")
  public GeoLocationInfo getGeoLocationInfo() {
    return geoLocationInfo;
  }

  public void setGeoLocationInfo(GeoLocationInfo geoLocationInfo) {
    this.geoLocationInfo = geoLocationInfo;
  }

  public PaymentSearchResult metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Связанные с платежом метаданные
   * @return metadata
  **/
  @ApiModelProperty(value = "Связанные с платежом метаданные")
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public PaymentSearchResult invoiceMetadata(Object invoiceMetadata) {
    this.invoiceMetadata = invoiceMetadata;
    return this;
  }

   /**
   * Связанные с инвойсом метаданные
   * @return invoiceMetadata
  **/
  @ApiModelProperty(value = "Связанные с инвойсом метаданные")
  public Object getInvoiceMetadata() {
    return invoiceMetadata;
  }

  public void setInvoiceMetadata(Object invoiceMetadata) {
    this.invoiceMetadata = invoiceMetadata;
  }

  public PaymentSearchResult statusChangedAt(OffsetDateTime statusChangedAt) {
    this.statusChangedAt = statusChangedAt;
    return this;
  }

   /**
   * Дата и время изменения статуса платежа
   * @return statusChangedAt
  **/
  @ApiModelProperty(value = "Дата и время изменения статуса платежа")
  public OffsetDateTime getStatusChangedAt() {
    return statusChangedAt;
  }

  public void setStatusChangedAt(OffsetDateTime statusChangedAt) {
    this.statusChangedAt = statusChangedAt;
  }

   /**
   * Признак создания родительского рекуррентного платежа. Успешно проведеный платеж с этим признаком можно использовать как родительский в других рекуррентных платежах. 
   * @return makeRecurrent
  **/
  @ApiModelProperty(value = "Признак создания родительского рекуррентного платежа. Успешно проведеный платеж с этим признаком можно использовать как родительский в других рекуррентных платежах. ")
  public Boolean isMakeRecurrent() {
    return makeRecurrent;
  }

  public PaymentSearchResult cart(InvoiceCart cart) {
    this.cart = cart;
    return this;
  }

   /**
   * Get cart
   * @return cart
  **/
  @ApiModelProperty(value = "")
  public InvoiceCart getCart() {
    return cart;
  }

  public void setCart(InvoiceCart cart) {
    this.cart = cart;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentSearchResult paymentSearchResult = (PaymentSearchResult) o;
    return Objects.equals(this.status, paymentSearchResult.status) &&
        Objects.equals(this.error, paymentSearchResult.error) &&
        Objects.equals(this.id, paymentSearchResult.id) &&
        Objects.equals(this.shortID, paymentSearchResult.shortID) &&
        Objects.equals(this.invoiceID, paymentSearchResult.invoiceID) &&
        Objects.equals(this.shopID, paymentSearchResult.shopID) &&
        Objects.equals(this.createdAt, paymentSearchResult.createdAt) &&
        Objects.equals(this.amount, paymentSearchResult.amount) &&
        Objects.equals(this.fee, paymentSearchResult.fee) &&
        Objects.equals(this.currency, paymentSearchResult.currency) &&
        Objects.equals(this.payer, paymentSearchResult.payer) &&
        Objects.equals(this.flow, paymentSearchResult.flow) &&
        Objects.equals(this.geoLocationInfo, paymentSearchResult.geoLocationInfo) &&
        Objects.equals(this.metadata, paymentSearchResult.metadata) &&
        Objects.equals(this.invoiceMetadata, paymentSearchResult.invoiceMetadata) &&
        Objects.equals(this.statusChangedAt, paymentSearchResult.statusChangedAt) &&
        Objects.equals(this.makeRecurrent, paymentSearchResult.makeRecurrent) &&
        Objects.equals(this.cart, paymentSearchResult.cart);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, error, id, shortID, invoiceID, shopID, createdAt, amount, fee, currency, payer, flow, geoLocationInfo, metadata, invoiceMetadata, statusChangedAt, makeRecurrent, cart);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentSearchResult {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    shortID: ").append(toIndentedString(shortID)).append("\n");
    sb.append("    invoiceID: ").append(toIndentedString(invoiceID)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    flow: ").append(toIndentedString(flow)).append("\n");
    sb.append("    geoLocationInfo: ").append(toIndentedString(geoLocationInfo)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    invoiceMetadata: ").append(toIndentedString(invoiceMetadata)).append("\n");
    sb.append("    statusChangedAt: ").append(toIndentedString(statusChangedAt)).append("\n");
    sb.append("    makeRecurrent: ").append(toIndentedString(makeRecurrent)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

