/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rbkmoney.swag.dark_api.model.CardData;
import com.rbkmoney.swag.dark_api.model.ClientInfo;
import com.rbkmoney.swag.dark_api.model.InvoiceCart;
import com.rbkmoney.swag.dark_api.model.PaymentFlow;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;

/**
 * PaymentParams
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class PaymentParams {
  @JsonProperty("externalID")
  private String externalID = null;

  @JsonProperty("shopID")
  private String shopID = null;

  @JsonProperty("dueDate")
  private OffsetDateTime dueDate = null;

  @JsonProperty("amount")
  private Long amount = null;

  @JsonProperty("flow")
  private PaymentFlow flow = null;

  @JsonProperty("cardData")
  private CardData cardData = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("product")
  private String product = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("cart")
  private InvoiceCart cart = null;

  @JsonProperty("metadata")
  private Object metadata = null;

  @JsonProperty("clientInfo")
  private ClientInfo clientInfo = null;

  public PaymentParams externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

   /**
   * Get externalID
   * @return externalID
  **/
  @ApiModelProperty(value = "")
  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public PaymentParams shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

   /**
   * Идентификатор магазина
   * @return shopID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public PaymentParams dueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
    return this;
  }

   /**
   * Дата и время окончания действия инвойса, после наступления которых его уже невозможно будет оплатить 
   * @return dueDate
  **/
  @ApiModelProperty(required = true, value = "Дата и время окончания действия инвойса, после наступления которых его уже невозможно будет оплатить ")
  public OffsetDateTime getDueDate() {
    return dueDate;
  }

  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
  }

  public PaymentParams amount(Long amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты.  Если стоимость не указана, то стоимостью инвойса будет считаться суммарная стоимость позиций в корзине. 
   * minimum: 1
   * @return amount
  **/
  @ApiModelProperty(value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты.  Если стоимость не указана, то стоимостью инвойса будет считаться суммарная стоимость позиций в корзине. ")
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public PaymentParams flow(PaymentFlow flow) {
    this.flow = flow;
    return this;
  }

   /**
   * Get flow
   * @return flow
  **/
  @ApiModelProperty(value = "")
  public PaymentFlow getFlow() {
    return flow;
  }

  public void setFlow(PaymentFlow flow) {
    this.flow = flow;
  }

  public PaymentParams cardData(CardData cardData) {
    this.cardData = cardData;
    return this;
  }

   /**
   * Get cardData
   * @return cardData
  **/
  @ApiModelProperty(value = "")
  public CardData getCardData() {
    return cardData;
  }

  public void setCardData(CardData cardData) {
    this.cardData = cardData;
  }

  public PaymentParams currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public PaymentParams product(String product) {
    this.product = product;
    return this;
  }

   /**
   * Наименование предлагаемых товаров или услуг
   * @return product
  **/
  @ApiModelProperty(required = true, value = "Наименование предлагаемых товаров или услуг")
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public PaymentParams description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Описание предлагаемых товаров или услуг
   * @return description
  **/
  @ApiModelProperty(value = "Описание предлагаемых товаров или услуг")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public PaymentParams cart(InvoiceCart cart) {
    this.cart = cart;
    return this;
  }

   /**
   * Get cart
   * @return cart
  **/
  @ApiModelProperty(value = "")
  public InvoiceCart getCart() {
    return cart;
  }

  public void setCart(InvoiceCart cart) {
    this.cart = cart;
  }

  public PaymentParams metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Метаданные, которые необходимо связать с инвойсом
   * @return metadata
  **/
  @ApiModelProperty(required = true, value = "Метаданные, которые необходимо связать с инвойсом")
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public PaymentParams clientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    return this;
  }

   /**
   * Get clientInfo
   * @return clientInfo
  **/
  @ApiModelProperty(required = true, value = "")
  public ClientInfo getClientInfo() {
    return clientInfo;
  }

  public void setClientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentParams paymentParams = (PaymentParams) o;
    return Objects.equals(this.externalID, paymentParams.externalID) &&
        Objects.equals(this.shopID, paymentParams.shopID) &&
        Objects.equals(this.dueDate, paymentParams.dueDate) &&
        Objects.equals(this.amount, paymentParams.amount) &&
        Objects.equals(this.flow, paymentParams.flow) &&
        Objects.equals(this.cardData, paymentParams.cardData) &&
        Objects.equals(this.currency, paymentParams.currency) &&
        Objects.equals(this.product, paymentParams.product) &&
        Objects.equals(this.description, paymentParams.description) &&
        Objects.equals(this.cart, paymentParams.cart) &&
        Objects.equals(this.metadata, paymentParams.metadata) &&
        Objects.equals(this.clientInfo, paymentParams.clientInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(externalID, shopID, dueDate, amount, flow, cardData, currency, product, description, cart, metadata, clientInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentParams {\n");
    
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    flow: ").append(toIndentedString(flow)).append("\n");
    sb.append("    cardData: ").append(toIndentedString(cardData)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

