/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Сведения о миграционной карте
 */
@ApiModel(description = "Сведения о миграционной карте")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class MigrationCardInfo {
  @JsonProperty("card_number")
  private String cardNumber = null;

  @JsonProperty("beginning_date")
  private String beginningDate = null;

  @JsonProperty("expiration_date")
  private String expirationDate = null;

  public MigrationCardInfo cardNumber(String cardNumber) {
    this.cardNumber = cardNumber;
    return this;
  }

   /**
   * Является ли налоговым резидентом США или иного иностранного государства
   * @return cardNumber
  **/
  @ApiModelProperty(value = "Является ли налоговым резидентом США или иного иностранного государства")
  public String getCardNumber() {
    return cardNumber;
  }

  public void setCardNumber(String cardNumber) {
    this.cardNumber = cardNumber;
  }

  public MigrationCardInfo beginningDate(String beginningDate) {
    this.beginningDate = beginningDate;
    return this;
  }

   /**
   * Дата начала срока пребывания
   * @return beginningDate
  **/
  @ApiModelProperty(value = "Дата начала срока пребывания")
  public String getBeginningDate() {
    return beginningDate;
  }

  public void setBeginningDate(String beginningDate) {
    this.beginningDate = beginningDate;
  }

  public MigrationCardInfo expirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
    return this;
  }

   /**
   * Дата окончания срока пребывания
   * @return expirationDate
  **/
  @ApiModelProperty(value = "Дата окончания срока пребывания")
  public String getExpirationDate() {
    return expirationDate;
  }

  public void setExpirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrationCardInfo migrationCardInfo = (MigrationCardInfo) o;
    return Objects.equals(this.cardNumber, migrationCardInfo.cardNumber) &&
        Objects.equals(this.beginningDate, migrationCardInfo.beginningDate) &&
        Objects.equals(this.expirationDate, migrationCardInfo.expirationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardNumber, beginningDate, expirationDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrationCardInfo {\n");
    
    sb.append("    cardNumber: ").append(toIndentedString(cardNumber)).append("\n");
    sb.append("    beginningDate: ").append(toIndentedString(beginningDate)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

