/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Сведения о принадлежности физического лица к некоторым категориям граждан
 */
@ApiModel(description = "Сведения о принадлежности физического лица к некоторым категориям граждан")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class IndividualPersonCategories {
  @JsonProperty("foreign_public_person")
  private Boolean foreignPublicPerson = null;

  @JsonProperty("foreign_relative_person")
  private Boolean foreignRelativePerson = null;

  @JsonProperty("behalf_of_foreign")
  private Boolean behalfOfForeign = null;

  @JsonProperty("worldwide_org_public_person")
  private Boolean worldwideOrgPublicPerson = null;

  @JsonProperty("has_representative")
  private Boolean hasRepresentative = null;

  @JsonProperty("beneficial_owner")
  private Boolean beneficialOwner = null;

  public IndividualPersonCategories foreignPublicPerson(Boolean foreignPublicPerson) {
    this.foreignPublicPerson = foreignPublicPerson;
    return this;
  }

   /**
   * Является иностранным публичным должностным лицом
   * @return foreignPublicPerson
  **/
  @ApiModelProperty(value = "Является иностранным публичным должностным лицом")
  public Boolean isForeignPublicPerson() {
    return foreignPublicPerson;
  }

  public void setForeignPublicPerson(Boolean foreignPublicPerson) {
    this.foreignPublicPerson = foreignPublicPerson;
  }

  public IndividualPersonCategories foreignRelativePerson(Boolean foreignRelativePerson) {
    this.foreignRelativePerson = foreignRelativePerson;
    return this;
  }

   /**
   * Является родственником инностранного публичного должностного лица
   * @return foreignRelativePerson
  **/
  @ApiModelProperty(value = "Является родственником инностранного публичного должностного лица")
  public Boolean isForeignRelativePerson() {
    return foreignRelativePerson;
  }

  public void setForeignRelativePerson(Boolean foreignRelativePerson) {
    this.foreignRelativePerson = foreignRelativePerson;
  }

  public IndividualPersonCategories behalfOfForeign(Boolean behalfOfForeign) {
    this.behalfOfForeign = behalfOfForeign;
    return this;
  }

   /**
   * Действует от имени иностранного лица
   * @return behalfOfForeign
  **/
  @ApiModelProperty(value = "Действует от имени иностранного лица")
  public Boolean isBehalfOfForeign() {
    return behalfOfForeign;
  }

  public void setBehalfOfForeign(Boolean behalfOfForeign) {
    this.behalfOfForeign = behalfOfForeign;
  }

  public IndividualPersonCategories worldwideOrgPublicPerson(Boolean worldwideOrgPublicPerson) {
    this.worldwideOrgPublicPerson = worldwideOrgPublicPerson;
    return this;
  }

   /**
   * Является должностным лицом публичной международной организации; лицом замещающим государственные должности
   * @return worldwideOrgPublicPerson
  **/
  @ApiModelProperty(value = "Является должностным лицом публичной международной организации; лицом замещающим государственные должности")
  public Boolean isWorldwideOrgPublicPerson() {
    return worldwideOrgPublicPerson;
  }

  public void setWorldwideOrgPublicPerson(Boolean worldwideOrgPublicPerson) {
    this.worldwideOrgPublicPerson = worldwideOrgPublicPerson;
  }

  public IndividualPersonCategories hasRepresentative(Boolean hasRepresentative) {
    this.hasRepresentative = hasRepresentative;
    return this;
  }

   /**
   * Имеется представитель клиента
   * @return hasRepresentative
  **/
  @ApiModelProperty(value = "Имеется представитель клиента")
  public Boolean isHasRepresentative() {
    return hasRepresentative;
  }

  public void setHasRepresentative(Boolean hasRepresentative) {
    this.hasRepresentative = hasRepresentative;
  }

  public IndividualPersonCategories beneficialOwner(Boolean beneficialOwner) {
    this.beneficialOwner = beneficialOwner;
    return this;
  }

   /**
   * Бенефициарным владельцем клиента является сам клиент
   * @return beneficialOwner
  **/
  @ApiModelProperty(value = "Бенефициарным владельцем клиента является сам клиент")
  public Boolean isBeneficialOwner() {
    return beneficialOwner;
  }

  public void setBeneficialOwner(Boolean beneficialOwner) {
    this.beneficialOwner = beneficialOwner;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IndividualPersonCategories individualPersonCategories = (IndividualPersonCategories) o;
    return Objects.equals(this.foreignPublicPerson, individualPersonCategories.foreignPublicPerson) &&
        Objects.equals(this.foreignRelativePerson, individualPersonCategories.foreignRelativePerson) &&
        Objects.equals(this.behalfOfForeign, individualPersonCategories.behalfOfForeign) &&
        Objects.equals(this.worldwideOrgPublicPerson, individualPersonCategories.worldwideOrgPublicPerson) &&
        Objects.equals(this.hasRepresentative, individualPersonCategories.hasRepresentative) &&
        Objects.equals(this.beneficialOwner, individualPersonCategories.beneficialOwner);
  }

  @Override
  public int hashCode() {
    return Objects.hash(foreignPublicPerson, foreignRelativePerson, behalfOfForeign, worldwideOrgPublicPerson, hasRepresentative, beneficialOwner);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IndividualPersonCategories {\n");
    
    sb.append("    foreignPublicPerson: ").append(toIndentedString(foreignPublicPerson)).append("\n");
    sb.append("    foreignRelativePerson: ").append(toIndentedString(foreignRelativePerson)).append("\n");
    sb.append("    behalfOfForeign: ").append(toIndentedString(behalfOfForeign)).append("\n");
    sb.append("    worldwideOrgPublicPerson: ").append(toIndentedString(worldwideOrgPublicPerson)).append("\n");
    sb.append("    hasRepresentative: ").append(toIndentedString(hasRepresentative)).append("\n");
    sb.append("    beneficialOwner: ").append(toIndentedString(beneficialOwner)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

