/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rbkmoney.swag.dark_api.model.Founder;
import com.rbkmoney.swag.dark_api.model.FounderHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * FoundersInfo
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class FoundersInfo {
  @JsonProperty("founders")
  private List<Founder> founders = null;

  @JsonProperty("heads")
  private List<FounderHead> heads = null;

  @JsonProperty("legal_owner")
  private FounderHead legalOwner = null;

  public FoundersInfo founders(List<Founder> founders) {
    this.founders = founders;
    return this;
  }

  public FoundersInfo addFoundersItem(Founder foundersItem) {
    if (this.founders == null) {
      this.founders = new ArrayList<>();
    }
    this.founders.add(foundersItem);
    return this;
  }

   /**
   * Get founders
   * @return founders
  **/
  @ApiModelProperty(value = "")
  public List<Founder> getFounders() {
    return founders;
  }

  public void setFounders(List<Founder> founders) {
    this.founders = founders;
  }

  public FoundersInfo heads(List<FounderHead> heads) {
    this.heads = heads;
    return this;
  }

  public FoundersInfo addHeadsItem(FounderHead headsItem) {
    if (this.heads == null) {
      this.heads = new ArrayList<>();
    }
    this.heads.add(headsItem);
    return this;
  }

   /**
   * Get heads
   * @return heads
  **/
  @ApiModelProperty(value = "")
  public List<FounderHead> getHeads() {
    return heads;
  }

  public void setHeads(List<FounderHead> heads) {
    this.heads = heads;
  }

  public FoundersInfo legalOwner(FounderHead legalOwner) {
    this.legalOwner = legalOwner;
    return this;
  }

   /**
   * Get legalOwner
   * @return legalOwner
  **/
  @ApiModelProperty(value = "")
  public FounderHead getLegalOwner() {
    return legalOwner;
  }

  public void setLegalOwner(FounderHead legalOwner) {
    this.legalOwner = legalOwner;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FoundersInfo foundersInfo = (FoundersInfo) o;
    return Objects.equals(this.founders, foundersInfo.founders) &&
        Objects.equals(this.heads, foundersInfo.heads) &&
        Objects.equals(this.legalOwner, foundersInfo.legalOwner);
  }

  @Override
  public int hashCode() {
    return Objects.hash(founders, heads, legalOwner);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FoundersInfo {\n");
    
    sb.append("    founders: ").append(toIndentedString(founders)).append("\n");
    sb.append("    heads: ").append(toIndentedString(heads)).append("\n");
    sb.append("    legalOwner: ").append(toIndentedString(legalOwner)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

