/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rbkmoney.swag.dark_api.model.IdentityDocument;
import com.rbkmoney.swag.dark_api.model.MigrationCardInfo;
import com.rbkmoney.swag.dark_api.model.ResidenceApprove;
import com.rbkmoney.swag.dark_api.model.RussianPrivateEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Бенефициарный владелец
 */
@ApiModel(description = "Бенефициарный владелец")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class BeneficialOwner {
  @JsonProperty("ownership_percentage")
  private Integer ownershipPercentage = null;

  @JsonProperty("russian_private_entity")
  private RussianPrivateEntity russianPrivateEntity = null;

  @JsonProperty("inn")
  private String inn = null;

  @JsonProperty("identity_document")
  private IdentityDocument identityDocument = null;

  @JsonProperty("migration_card_info")
  private MigrationCardInfo migrationCardInfo = null;

  @JsonProperty("residence_approve")
  private ResidenceApprove residenceApprove = null;

  @JsonProperty("pdl_category")
  private Boolean pdlCategory = null;

  public BeneficialOwner ownershipPercentage(Integer ownershipPercentage) {
    this.ownershipPercentage = ownershipPercentage;
    return this;
  }

   /**
   * Get ownershipPercentage
   * minimum: 1
   * @return ownershipPercentage
  **/
  @ApiModelProperty(value = "")
  public Integer getOwnershipPercentage() {
    return ownershipPercentage;
  }

  public void setOwnershipPercentage(Integer ownershipPercentage) {
    this.ownershipPercentage = ownershipPercentage;
  }

  public BeneficialOwner russianPrivateEntity(RussianPrivateEntity russianPrivateEntity) {
    this.russianPrivateEntity = russianPrivateEntity;
    return this;
  }

   /**
   * Get russianPrivateEntity
   * @return russianPrivateEntity
  **/
  @ApiModelProperty(value = "")
  public RussianPrivateEntity getRussianPrivateEntity() {
    return russianPrivateEntity;
  }

  public void setRussianPrivateEntity(RussianPrivateEntity russianPrivateEntity) {
    this.russianPrivateEntity = russianPrivateEntity;
  }

  public BeneficialOwner inn(String inn) {
    this.inn = inn;
    return this;
  }

   /**
   * ИНН
   * @return inn
  **/
  @ApiModelProperty(value = "ИНН")
  public String getInn() {
    return inn;
  }

  public void setInn(String inn) {
    this.inn = inn;
  }

  public BeneficialOwner identityDocument(IdentityDocument identityDocument) {
    this.identityDocument = identityDocument;
    return this;
  }

   /**
   * Get identityDocument
   * @return identityDocument
  **/
  @ApiModelProperty(value = "")
  public IdentityDocument getIdentityDocument() {
    return identityDocument;
  }

  public void setIdentityDocument(IdentityDocument identityDocument) {
    this.identityDocument = identityDocument;
  }

  public BeneficialOwner migrationCardInfo(MigrationCardInfo migrationCardInfo) {
    this.migrationCardInfo = migrationCardInfo;
    return this;
  }

   /**
   * Get migrationCardInfo
   * @return migrationCardInfo
  **/
  @ApiModelProperty(value = "")
  public MigrationCardInfo getMigrationCardInfo() {
    return migrationCardInfo;
  }

  public void setMigrationCardInfo(MigrationCardInfo migrationCardInfo) {
    this.migrationCardInfo = migrationCardInfo;
  }

  public BeneficialOwner residenceApprove(ResidenceApprove residenceApprove) {
    this.residenceApprove = residenceApprove;
    return this;
  }

   /**
   * Get residenceApprove
   * @return residenceApprove
  **/
  @ApiModelProperty(value = "")
  public ResidenceApprove getResidenceApprove() {
    return residenceApprove;
  }

  public void setResidenceApprove(ResidenceApprove residenceApprove) {
    this.residenceApprove = residenceApprove;
  }

  public BeneficialOwner pdlCategory(Boolean pdlCategory) {
    this.pdlCategory = pdlCategory;
    return this;
  }

   /**
   * Get pdlCategory
   * @return pdlCategory
  **/
  @ApiModelProperty(value = "")
  public Boolean isPdlCategory() {
    return pdlCategory;
  }

  public void setPdlCategory(Boolean pdlCategory) {
    this.pdlCategory = pdlCategory;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BeneficialOwner beneficialOwner = (BeneficialOwner) o;
    return Objects.equals(this.ownershipPercentage, beneficialOwner.ownershipPercentage) &&
        Objects.equals(this.russianPrivateEntity, beneficialOwner.russianPrivateEntity) &&
        Objects.equals(this.inn, beneficialOwner.inn) &&
        Objects.equals(this.identityDocument, beneficialOwner.identityDocument) &&
        Objects.equals(this.migrationCardInfo, beneficialOwner.migrationCardInfo) &&
        Objects.equals(this.residenceApprove, beneficialOwner.residenceApprove) &&
        Objects.equals(this.pdlCategory, beneficialOwner.pdlCategory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ownershipPercentage, russianPrivateEntity, inn, identityDocument, migrationCardInfo, residenceApprove, pdlCategory);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BeneficialOwner {\n");
    
    sb.append("    ownershipPercentage: ").append(toIndentedString(ownershipPercentage)).append("\n");
    sb.append("    russianPrivateEntity: ").append(toIndentedString(russianPrivateEntity)).append("\n");
    sb.append("    inn: ").append(toIndentedString(inn)).append("\n");
    sb.append("    identityDocument: ").append(toIndentedString(identityDocument)).append("\n");
    sb.append("    migrationCardInfo: ").append(toIndentedString(migrationCardInfo)).append("\n");
    sb.append("    residenceApprove: ").append(toIndentedString(residenceApprove)).append("\n");
    sb.append("    pdlCategory: ").append(toIndentedString(pdlCategory)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

