/*
 * RBKmoney Dark Resource API
 *  ## Описание RBKmoney Dark Resource API служит для управления секретных вызовов. Любые сторонние приложения, включая наши веб-сайты и другие UI-интерфейсы являются внешними приложениями-клиентами. RBKmoney API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. 
 *
 * OpenAPI spec version: 0.0.1
 * Contact: support@rbk.money
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.rbkmoney.swag.dark_api.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rbkmoney.swag.dark_api.model.BankAccount;
import com.rbkmoney.swag.dark_api.model.BusinessInfo;
import com.rbkmoney.swag.dark_api.model.BusinessReputation;
import com.rbkmoney.swag.dark_api.model.FinancialPosition;
import com.rbkmoney.swag.dark_api.model.MonthOperationCount;
import com.rbkmoney.swag.dark_api.model.MonthOperationSum;
import com.rbkmoney.swag.dark_api.model.RelationIndividualEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * Сведения о целях установления и предполагаемом характере отношения с НКО, сведения о целях финансово-хозяйственной деятельности индвидидуального предпринимателя, деловая репутация 
 */
@ApiModel(description = "Сведения о целях установления и предполагаемом характере отношения с НКО, сведения о целях финансово-хозяйственной деятельности индвидидуального предпринимателя, деловая репутация ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
public class AdditionalInfo {
  @JsonProperty("staff_count")
  private Integer staffCount = 1;

  @JsonProperty("has_accountant")
  private Boolean hasAccountant = null;

  @JsonProperty("accounting")
  private String accounting = null;

  @JsonProperty("accounting_org")
  private String accountingOrg = null;

  @JsonProperty("nko_relation_target")
  private String nkoRelationTarget = null;

  @JsonProperty("relationship_with_nko")
  private String relationshipWithNko = null;

  @JsonProperty("month_operation_count")
  private MonthOperationCount monthOperationCount = null;

  @JsonProperty("month_operation_sum")
  private MonthOperationSum monthOperationSum = null;

  @JsonProperty("financial_position")
  private List<FinancialPosition> financialPosition = null;

  @JsonProperty("business_info")
  private List<BusinessInfo> businessInfo = null;

  @JsonProperty("storage_facilities")
  private Boolean storageFacilities = null;

  @JsonProperty("main_counterparties")
  private String mainCounterparties = null;

  @JsonProperty("relation_individual_entity")
  private RelationIndividualEntity relationIndividualEntity = null;

  @JsonProperty("benefit_third_parties")
  private Boolean benefitThirdParties = null;

  @JsonProperty("business_reputation")
  private BusinessReputation businessReputation = null;

  @JsonProperty("russian_bank_account")
  private BankAccount russianBankAccount = null;

  public AdditionalInfo staffCount(Integer staffCount) {
    this.staffCount = staffCount;
    return this;
  }

   /**
   * Штатная численность
   * minimum: 1
   * @return staffCount
  **/
  @ApiModelProperty(value = "Штатная численность")
  public Integer getStaffCount() {
    return staffCount;
  }

  public void setStaffCount(Integer staffCount) {
    this.staffCount = staffCount;
  }

  public AdditionalInfo hasAccountant(Boolean hasAccountant) {
    this.hasAccountant = hasAccountant;
    return this;
  }

   /**
   * Наличие в штате главного бухгалтера
   * @return hasAccountant
  **/
  @ApiModelProperty(value = "Наличие в штате главного бухгалтера")
  public Boolean isHasAccountant() {
    return hasAccountant;
  }

  public void setHasAccountant(Boolean hasAccountant) {
    this.hasAccountant = hasAccountant;
  }

  public AdditionalInfo accounting(String accounting) {
    this.accounting = accounting;
    return this;
  }

   /**
   * Бух.учет ведется самим предпринимателем (в случае отстутсвия в штате главного бухгалтера)
   * @return accounting
  **/
  @ApiModelProperty(value = "Бух.учет ведется самим предпринимателем (в случае отстутсвия в штате главного бухгалтера)")
  public String getAccounting() {
    return accounting;
  }

  public void setAccounting(String accounting) {
    this.accounting = accounting;
  }

  public AdditionalInfo accountingOrg(String accountingOrg) {
    this.accountingOrg = accountingOrg;
    return this;
  }

   /**
   * Сведения об организации, ведущей бухгалтерский учет (наименование, договор, иной документ)
   * @return accountingOrg
  **/
  @ApiModelProperty(value = "Сведения об организации, ведущей бухгалтерский учет (наименование, договор, иной документ)")
  public String getAccountingOrg() {
    return accountingOrg;
  }

  public void setAccountingOrg(String accountingOrg) {
    this.accountingOrg = accountingOrg;
  }

  public AdditionalInfo nkoRelationTarget(String nkoRelationTarget) {
    this.nkoRelationTarget = nkoRelationTarget;
    return this;
  }

   /**
   * Цели установления деловых отношения с НКО
   * @return nkoRelationTarget
  **/
  @ApiModelProperty(value = "Цели установления деловых отношения с НКО")
  public String getNkoRelationTarget() {
    return nkoRelationTarget;
  }

  public void setNkoRelationTarget(String nkoRelationTarget) {
    this.nkoRelationTarget = nkoRelationTarget;
  }

  public AdditionalInfo relationshipWithNko(String relationshipWithNko) {
    this.relationshipWithNko = relationshipWithNko;
    return this;
  }

   /**
   * Предполагаемый характер деловых отношений с НКО
   * @return relationshipWithNko
  **/
  @ApiModelProperty(value = "Предполагаемый характер деловых отношений с НКО")
  public String getRelationshipWithNko() {
    return relationshipWithNko;
  }

  public void setRelationshipWithNko(String relationshipWithNko) {
    this.relationshipWithNko = relationshipWithNko;
  }

  public AdditionalInfo monthOperationCount(MonthOperationCount monthOperationCount) {
    this.monthOperationCount = monthOperationCount;
    return this;
  }

   /**
   * Get monthOperationCount
   * @return monthOperationCount
  **/
  @ApiModelProperty(value = "")
  public MonthOperationCount getMonthOperationCount() {
    return monthOperationCount;
  }

  public void setMonthOperationCount(MonthOperationCount monthOperationCount) {
    this.monthOperationCount = monthOperationCount;
  }

  public AdditionalInfo monthOperationSum(MonthOperationSum monthOperationSum) {
    this.monthOperationSum = monthOperationSum;
    return this;
  }

   /**
   * Get monthOperationSum
   * @return monthOperationSum
  **/
  @ApiModelProperty(value = "")
  public MonthOperationSum getMonthOperationSum() {
    return monthOperationSum;
  }

  public void setMonthOperationSum(MonthOperationSum monthOperationSum) {
    this.monthOperationSum = monthOperationSum;
  }

  public AdditionalInfo financialPosition(List<FinancialPosition> financialPosition) {
    this.financialPosition = financialPosition;
    return this;
  }

  public AdditionalInfo addFinancialPositionItem(FinancialPosition financialPositionItem) {
    if (this.financialPosition == null) {
      this.financialPosition = new ArrayList<>();
    }
    this.financialPosition.add(financialPositionItem);
    return this;
  }

   /**
   * Get financialPosition
   * @return financialPosition
  **/
  @ApiModelProperty(value = "")
  public List<FinancialPosition> getFinancialPosition() {
    return financialPosition;
  }

  public void setFinancialPosition(List<FinancialPosition> financialPosition) {
    this.financialPosition = financialPosition;
  }

  public AdditionalInfo businessInfo(List<BusinessInfo> businessInfo) {
    this.businessInfo = businessInfo;
    return this;
  }

  public AdditionalInfo addBusinessInfoItem(BusinessInfo businessInfoItem) {
    if (this.businessInfo == null) {
      this.businessInfo = new ArrayList<>();
    }
    this.businessInfo.add(businessInfoItem);
    return this;
  }

   /**
   * Get businessInfo
   * @return businessInfo
  **/
  @ApiModelProperty(value = "")
  public List<BusinessInfo> getBusinessInfo() {
    return businessInfo;
  }

  public void setBusinessInfo(List<BusinessInfo> businessInfo) {
    this.businessInfo = businessInfo;
  }

  public AdditionalInfo storageFacilities(Boolean storageFacilities) {
    this.storageFacilities = storageFacilities;
    return this;
  }

   /**
   * Наличие складских помещений
   * @return storageFacilities
  **/
  @ApiModelProperty(value = "Наличие складских помещений")
  public Boolean isStorageFacilities() {
    return storageFacilities;
  }

  public void setStorageFacilities(Boolean storageFacilities) {
    this.storageFacilities = storageFacilities;
  }

  public AdditionalInfo mainCounterparties(String mainCounterparties) {
    this.mainCounterparties = mainCounterparties;
    return this;
  }

   /**
   * Основные контагенты
   * @return mainCounterparties
  **/
  @ApiModelProperty(value = "Основные контагенты")
  public String getMainCounterparties() {
    return mainCounterparties;
  }

  public void setMainCounterparties(String mainCounterparties) {
    this.mainCounterparties = mainCounterparties;
  }

  public AdditionalInfo relationIndividualEntity(RelationIndividualEntity relationIndividualEntity) {
    this.relationIndividualEntity = relationIndividualEntity;
    return this;
  }

   /**
   * Get relationIndividualEntity
   * @return relationIndividualEntity
  **/
  @ApiModelProperty(value = "")
  public RelationIndividualEntity getRelationIndividualEntity() {
    return relationIndividualEntity;
  }

  public void setRelationIndividualEntity(RelationIndividualEntity relationIndividualEntity) {
    this.relationIndividualEntity = relationIndividualEntity;
  }

  public AdditionalInfo benefitThirdParties(Boolean benefitThirdParties) {
    this.benefitThirdParties = benefitThirdParties;
    return this;
  }

   /**
   * Действует ли к выгоде третьх лиц
   * @return benefitThirdParties
  **/
  @ApiModelProperty(value = "Действует ли к выгоде третьх лиц")
  public Boolean isBenefitThirdParties() {
    return benefitThirdParties;
  }

  public void setBenefitThirdParties(Boolean benefitThirdParties) {
    this.benefitThirdParties = benefitThirdParties;
  }

  public AdditionalInfo businessReputation(BusinessReputation businessReputation) {
    this.businessReputation = businessReputation;
    return this;
  }

   /**
   * Get businessReputation
   * @return businessReputation
  **/
  @ApiModelProperty(value = "")
  public BusinessReputation getBusinessReputation() {
    return businessReputation;
  }

  public void setBusinessReputation(BusinessReputation businessReputation) {
    this.businessReputation = businessReputation;
  }

  public AdditionalInfo russianBankAccount(BankAccount russianBankAccount) {
    this.russianBankAccount = russianBankAccount;
    return this;
  }

   /**
   * Get russianBankAccount
   * @return russianBankAccount
  **/
  @ApiModelProperty(value = "")
  public BankAccount getRussianBankAccount() {
    return russianBankAccount;
  }

  public void setRussianBankAccount(BankAccount russianBankAccount) {
    this.russianBankAccount = russianBankAccount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalInfo additionalInfo = (AdditionalInfo) o;
    return Objects.equals(this.staffCount, additionalInfo.staffCount) &&
        Objects.equals(this.hasAccountant, additionalInfo.hasAccountant) &&
        Objects.equals(this.accounting, additionalInfo.accounting) &&
        Objects.equals(this.accountingOrg, additionalInfo.accountingOrg) &&
        Objects.equals(this.nkoRelationTarget, additionalInfo.nkoRelationTarget) &&
        Objects.equals(this.relationshipWithNko, additionalInfo.relationshipWithNko) &&
        Objects.equals(this.monthOperationCount, additionalInfo.monthOperationCount) &&
        Objects.equals(this.monthOperationSum, additionalInfo.monthOperationSum) &&
        Objects.equals(this.financialPosition, additionalInfo.financialPosition) &&
        Objects.equals(this.businessInfo, additionalInfo.businessInfo) &&
        Objects.equals(this.storageFacilities, additionalInfo.storageFacilities) &&
        Objects.equals(this.mainCounterparties, additionalInfo.mainCounterparties) &&
        Objects.equals(this.relationIndividualEntity, additionalInfo.relationIndividualEntity) &&
        Objects.equals(this.benefitThirdParties, additionalInfo.benefitThirdParties) &&
        Objects.equals(this.businessReputation, additionalInfo.businessReputation) &&
        Objects.equals(this.russianBankAccount, additionalInfo.russianBankAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(staffCount, hasAccountant, accounting, accountingOrg, nkoRelationTarget, relationshipWithNko, monthOperationCount, monthOperationSum, financialPosition, businessInfo, storageFacilities, mainCounterparties, relationIndividualEntity, benefitThirdParties, businessReputation, russianBankAccount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalInfo {\n");
    
    sb.append("    staffCount: ").append(toIndentedString(staffCount)).append("\n");
    sb.append("    hasAccountant: ").append(toIndentedString(hasAccountant)).append("\n");
    sb.append("    accounting: ").append(toIndentedString(accounting)).append("\n");
    sb.append("    accountingOrg: ").append(toIndentedString(accountingOrg)).append("\n");
    sb.append("    nkoRelationTarget: ").append(toIndentedString(nkoRelationTarget)).append("\n");
    sb.append("    relationshipWithNko: ").append(toIndentedString(relationshipWithNko)).append("\n");
    sb.append("    monthOperationCount: ").append(toIndentedString(monthOperationCount)).append("\n");
    sb.append("    monthOperationSum: ").append(toIndentedString(monthOperationSum)).append("\n");
    sb.append("    financialPosition: ").append(toIndentedString(financialPosition)).append("\n");
    sb.append("    businessInfo: ").append(toIndentedString(businessInfo)).append("\n");
    sb.append("    storageFacilities: ").append(toIndentedString(storageFacilities)).append("\n");
    sb.append("    mainCounterparties: ").append(toIndentedString(mainCounterparties)).append("\n");
    sb.append("    relationIndividualEntity: ").append(toIndentedString(relationIndividualEntity)).append("\n");
    sb.append("    benefitThirdParties: ").append(toIndentedString(benefitThirdParties)).append("\n");
    sb.append("    businessReputation: ").append(toIndentedString(businessReputation)).append("\n");
    sb.append("    russianBankAccount: ").append(toIndentedString(russianBankAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

