package com.rbkmoney.swag.dark_api.api;

import com.rbkmoney.swag.dark_api.ApiClient;

import com.rbkmoney.swag.dark_api.model.GeneralError;
import com.rbkmoney.swag.dark_api.model.InlineResponse200;
import com.rbkmoney.swag.dark_api.model.InlineResponse400;
import java.time.OffsetDateTime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
@Component("com.rbkmoney.swag.dark_api.api.SearchApi")
public class SearchApi {
    private ApiClient apiClient;

    public SearchApi() {
        this(new ApiClient());
    }

    @Autowired
    public SearchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * Поиск платежей
     * <p><b>200</b> - Найденные платежи
     * <p><b>400</b> - Ошибочные данные в поиске платежей
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param shopID Идентификатор магазина
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param limit Лимит выборки
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param paymentStatus Статус платежа для поиска
     * @param paymentFlow Flow платежа
     * @param paymentMethod Метод оплаты
     * @param paymentTerminalProvider Провайдер платежного терминала
     * @param invoiceID Идентификатор инвойса
     * @param paymentID Идентификатор платежа
     * @param payerEmail Email, указанный при оплате
     * @param payerIP IP-адрес плательщика
     * @param payerFingerprint Уникальный отпечаток user agent&#39;а плательщика
     * @param customerID Идентификатор плательщика
     * @param bin BIN банка-эмитента карты
     * @param lastDigits Последние цифры номера карты
     * @param bankCardTokenProvider Провайдер платежных токенов
     * @param bankCardPaymentSystem Платежная система
     * @param paymentAmount Сумма платежа
     * @param continuationToken Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот-же набор условий и полученый токен. Если токена нет, получена последняя часть данных. 
     * @return InlineResponse200
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse200 searchPayments(String xRequestID, String shopID, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, String xRequestDeadline, String paymentStatus, String paymentFlow, String paymentMethod, String paymentTerminalProvider, String invoiceID, String paymentID, String payerEmail, String payerIP, String payerFingerprint, String customerID, String bin, String lastDigits, String bankCardTokenProvider, String bankCardPaymentSystem, Long paymentAmount, String continuationToken) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchPayments");
        }
        
        // verify the required parameter 'shopID' is set
        if (shopID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'shopID' when calling searchPayments");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchPayments");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchPayments");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling searchPayments");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("shopID", shopID);
        String path = UriComponentsBuilder.fromPath("/search/payments/{shopID}").buildAndExpand(uriVariables).toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentStatus", paymentStatus));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentFlow", paymentFlow));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentMethod", paymentMethod));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentTerminalProvider", paymentTerminalProvider));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceID", invoiceID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentID", paymentID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "payerEmail", payerEmail));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "payerIP", payerIP));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "payerFingerprint", payerFingerprint));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "customerID", customerID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bin", bin));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "lastDigits", lastDigits));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bankCardTokenProvider", bankCardTokenProvider));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bankCardPaymentSystem", bankCardPaymentSystem));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentAmount", paymentAmount));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse200> returnType = new ParameterizedTypeReference<InlineResponse200>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Поиск возвратов
     * <p><b>200</b> - Найденные возвраты
     * <p><b>400</b> - Ошибочные данные в поиске возвратов
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param shopID Идентификатор магазина
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param limit Лимит выборки
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param invoiceID Идентификатор инвойса
     * @param paymentID Идентификатор платежа
     * @param refundID Идентификатор возврата
     * @param refundStatus Статус возврата
     * @param continuationToken Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот-же набор условий и полученый токен. Если токена нет, получена последняя часть данных. 
     * @return InlineResponse200
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse200 searchRefunds(String xRequestID, String shopID, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, String xRequestDeadline, String invoiceID, String paymentID, String refundID, String refundStatus, String continuationToken) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchRefunds");
        }
        
        // verify the required parameter 'shopID' is set
        if (shopID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'shopID' when calling searchRefunds");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchRefunds");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchRefunds");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling searchRefunds");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("shopID", shopID);
        String path = UriComponentsBuilder.fromPath("/search/refunds/{shopID}").buildAndExpand(uriVariables).toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceID", invoiceID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentID", paymentID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "refundID", refundID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "refundStatus", refundStatus));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse200> returnType = new ParameterizedTypeReference<InlineResponse200>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}
