package com.rbkmoney.swag.dark_api.api;

import com.rbkmoney.swag.dark_api.ApiClient;

import com.rbkmoney.swag.dark_api.model.FileData;
import com.rbkmoney.swag.dark_api.model.FileDownload;
import com.rbkmoney.swag.dark_api.model.FileUploadData;
import com.rbkmoney.swag.dark_api.model.FileUploadRequest;
import com.rbkmoney.swag.dark_api.model.GeneralError;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-16T11:43:38.587Z")
@Component("com.rbkmoney.swag.dark_api.api.FilesApi")
public class FilesApi {
    private ApiClient apiClient;

    public FilesApi() {
        this(new ApiClient());
    }

    @Autowired
    public FilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * Получить ссылку для скачивания файла
     * <p><b>200</b> - Данные для получения файла
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param fileID Идентификатор файла
     * @return FileDownload
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public FileDownload downloadFile(String xRequestID, String fileID) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling downloadFile");
        }
        
        // verify the required parameter 'fileID' is set
        if (fileID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fileID' when calling downloadFile");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("fileID", fileID);
        String path = UriComponentsBuilder.fromPath("/files/{fileID}/download").buildAndExpand(uriVariables).toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<FileDownload> returnType = new ParameterizedTypeReference<FileDownload>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получить информацию о файле
     * <p><b>200</b> - Данные файла
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param fileID Идентификатор файла
     * @return FileData
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public FileData getFileInfo(String xRequestID, String fileID) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getFileInfo");
        }
        
        // verify the required parameter 'fileID' is set
        if (fileID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fileID' when calling getFileInfo");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("fileID", fileID);
        String path = UriComponentsBuilder.fromPath("/files/{fileID}/info").buildAndExpand(uriVariables).toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<FileData> returnType = new ParameterizedTypeReference<FileData>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Создать новый файл и сгенерировать ссылку для выгрузки файла на сервер
     * <p><b>201</b> - Данные для загрузки файла на сервер
     * <p><b>401</b> - Ошибка авторизации
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param uploadFileRequest The uploadFileRequest parameter
     * @return FileUploadData
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public FileUploadData uploadFile(String xRequestID, FileUploadRequest uploadFileRequest) throws RestClientException {
        Object postBody = uploadFileRequest;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling uploadFile");
        }
        
        String path = UriComponentsBuilder.fromPath("/files/upload").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<FileUploadData> returnType = new ParameterizedTypeReference<FileUploadData>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}
