/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.anapi.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.anapi.v2.model.FileMeta;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.format.annotation.DateTimeFormat;

public class Report {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="createdAt")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @JsonProperty(value="fromTime")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime fromTime;
    @JsonProperty(value="toTime")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime toTime;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="reportType")
    private ReportTypeEnum reportType;
    @JsonProperty(value="partyID")
    private String partyID;
    @JsonProperty(value="shopID")
    private String shopID;
    @JsonProperty(value="files")
    @Valid
    private List<FileMeta> files = new ArrayList<FileMeta>();

    public Report id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0442\u0447\u0435\u0442\u0430")
    @NotNull
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Report createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f")
    @NotNull
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Report fromTime(OffsetDateTime fromTime) {
        this.fromTime = fromTime;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430")
    @NotNull
    @Valid
    public OffsetDateTime getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(OffsetDateTime fromTime) {
        this.fromTime = fromTime;
    }

    public Report toTime(OffsetDateTime toTime) {
        this.toTime = toTime;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043a\u043e\u043d\u0446\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430")
    @NotNull
    @Valid
    public OffsetDateTime getToTime() {
        return this.toTime;
    }

    public void setToTime(OffsetDateTime toTime) {
        this.toTime = toTime;
    }

    public Report status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430")
    @NotNull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Report reportType(ReportTypeEnum reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0422\u0438\u043f \u043e\u0442\u0447\u0435\u0442\u0430")
    @NotNull
    public ReportTypeEnum getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportTypeEnum reportType) {
        this.reportType = reportType;
    }

    public Report partyID(String partyID) {
        this.partyID = partyID;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430")
    @NotNull
    @Size(min=1, max=40)
    public @NotNull @Size(min=1, max=40) String getPartyID() {
        return this.partyID;
    }

    public void setPartyID(String partyID) {
        this.partyID = partyID;
    }

    public Report shopID(String shopID) {
        this.shopID = shopID;
        return this;
    }

    @ApiModelProperty(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430")
    @Size(min=1, max=40)
    public @Size(min=1, max=40) String getShopID() {
        return this.shopID;
    }

    public void setShopID(String shopID) {
        this.shopID = shopID;
    }

    public Report files(List<FileMeta> files) {
        this.files = files;
        return this;
    }

    public Report addFilesItem(FileMeta filesItem) {
        this.files.add(filesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public List<FileMeta> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileMeta> files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        return Objects.equals(this.id, report.id) && Objects.equals(this.createdAt, report.createdAt) && Objects.equals(this.fromTime, report.fromTime) && Objects.equals(this.toTime, report.toTime) && Objects.equals((Object)this.status, (Object)report.status) && Objects.equals((Object)this.reportType, (Object)report.reportType) && Objects.equals(this.partyID, report.partyID) && Objects.equals(this.shopID, report.shopID) && Objects.equals(this.files, report.files);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.fromTime, this.toTime, this.status, this.reportType, this.partyID, this.shopID, this.files});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Report {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    fromTime: ").append(this.toIndentedString(this.fromTime)).append("\n");
        sb.append("    toTime: ").append(this.toIndentedString(this.toTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString((Object)this.reportType)).append("\n");
        sb.append("    partyID: ").append(this.toIndentedString(this.partyID)).append("\n");
        sb.append("    shopID: ").append(this.toIndentedString(this.shopID)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        CREATED("created"),
        CANCELED("canceled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReportTypeEnum {
        PROVISIONOFSERVICE("provisionOfService"),
        PAYMENTREGISTRY("paymentRegistry");

        private String value;

        private ReportTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReportTypeEnum fromValue(String value) {
            for (ReportTypeEnum b : ReportTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

