package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * RefundAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-06-27T12:00:54.657334916Z[Etc/UTC]")
public class RefundAllOf   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("externalID")
  private String externalID;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("reason")
  private String reason;

  @JsonProperty("shopID")
  private String shopID;

  public RefundAllOf id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор возврата
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор возврата")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public RefundAllOf externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Внешний идентификатор
   * @return externalID
  */
  @ApiModelProperty(value = "Внешний идентификатор")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public RefundAllOf createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время осуществления
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время осуществления")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public RefundAllOf amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Сумма возврата, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "Сумма возврата, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public RefundAllOf currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public RefundAllOf reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * Причина осуществления возврата
   * @return reason
  */
  @ApiModelProperty(value = "Причина осуществления возврата")


  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public RefundAllOf shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  */
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundAllOf refundAllOf = (RefundAllOf) o;
    return Objects.equals(this.id, refundAllOf.id) &&
        Objects.equals(this.externalID, refundAllOf.externalID) &&
        Objects.equals(this.createdAt, refundAllOf.createdAt) &&
        Objects.equals(this.amount, refundAllOf.amount) &&
        Objects.equals(this.currency, refundAllOf.currency) &&
        Objects.equals(this.reason, refundAllOf.reason) &&
        Objects.equals(this.shopID, refundAllOf.shopID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, externalID, createdAt, amount, currency, reason, shopID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundAllOf {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

