package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.MobileCommerceDetails;
import dev.vality.anapi.v2.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * PaymentToolDetailsMobileCommerce
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-06-27T12:00:54.657334916Z[Etc/UTC]")
public class PaymentToolDetailsMobileCommerce extends PaymentToolDetails  {
  @JsonProperty("phoneNumber")
  private String phoneNumber;

  public PaymentToolDetailsMobileCommerce phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Маскированый номер мобильного телефона
   * @return phoneNumber
  */
  @ApiModelProperty(example = "+7******0102", required = true, value = "Маскированый номер мобильного телефона")
  @NotNull

@Pattern(regexp = "^\\+\\d\\*{1,10}\\d{2,4}$") 
  public String getPhoneNumber() {
    return phoneNumber;
  }

  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetailsMobileCommerce paymentToolDetailsMobileCommerce = (PaymentToolDetailsMobileCommerce) o;
    return Objects.equals(this.phoneNumber, paymentToolDetailsMobileCommerce.phoneNumber) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneNumber, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetailsMobileCommerce {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

