package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.BankCardDetails;
import dev.vality.anapi.v2.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * PaymentToolDetailsBankCard
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-06-27T12:00:54.657334916Z[Etc/UTC]")
public class PaymentToolDetailsBankCard extends PaymentToolDetails  {
  @JsonProperty("cardNumberMask")
  private String cardNumberMask;

  @JsonProperty("bin")
  private String bin;

  @JsonProperty("lastDigits")
  private String lastDigits;

  @JsonProperty("paymentSystem")
  private String paymentSystem;

  @JsonProperty("tokenProvider")
  private String tokenProvider;

  public PaymentToolDetailsBankCard cardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
    return this;
  }

  /**
   * Маскированый номер карты
   * @return cardNumberMask
  */
  @ApiModelProperty(required = true, value = "Маскированый номер карты")
  @NotNull

@Pattern(regexp = "^\\d{6,8}\\*+\\d{2,4}$") 
  public String getCardNumberMask() {
    return cardNumberMask;
  }

  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }

  public PaymentToolDetailsBankCard bin(String bin) {
    this.bin = bin;
    return this;
  }

  /**
   * BIN банка-эмитента карты
   * @return bin
  */
  @ApiModelProperty(value = "BIN банка-эмитента карты")

@Pattern(regexp = "^(\\d{0}|\\d{6,8})$") 
  public String getBin() {
    return bin;
  }

  public void setBin(String bin) {
    this.bin = bin;
  }

  public PaymentToolDetailsBankCard lastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
    return this;
  }

  /**
   * Последние цифры номера карты
   * @return lastDigits
  */
  @ApiModelProperty(value = "Последние цифры номера карты")

@Pattern(regexp = "^\\d{2,4}$") 
  public String getLastDigits() {
    return lastDigits;
  }

  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }

  public PaymentToolDetailsBankCard paymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
    return this;
  }

  /**
   * Платежная система
   * @return paymentSystem
  */
  @ApiModelProperty(example = "VISA", required = true, value = "Платежная система")
  @NotNull


  public String getPaymentSystem() {
    return paymentSystem;
  }

  public void setPaymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
  }

  public PaymentToolDetailsBankCard tokenProvider(String tokenProvider) {
    this.tokenProvider = tokenProvider;
    return this;
  }

  /**
   * Провайдер платежных токенов
   * @return tokenProvider
  */
  @ApiModelProperty(example = "APPLE PAY", value = "Провайдер платежных токенов")


  public String getTokenProvider() {
    return tokenProvider;
  }

  public void setTokenProvider(String tokenProvider) {
    this.tokenProvider = tokenProvider;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetailsBankCard paymentToolDetailsBankCard = (PaymentToolDetailsBankCard) o;
    return Objects.equals(this.cardNumberMask, paymentToolDetailsBankCard.cardNumberMask) &&
        Objects.equals(this.bin, paymentToolDetailsBankCard.bin) &&
        Objects.equals(this.lastDigits, paymentToolDetailsBankCard.lastDigits) &&
        Objects.equals(this.paymentSystem, paymentToolDetailsBankCard.paymentSystem) &&
        Objects.equals(this.tokenProvider, paymentToolDetailsBankCard.tokenProvider) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardNumberMask, bin, lastDigits, paymentSystem, tokenProvider, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetailsBankCard {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

