package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * OffsetAmount
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-06-27T12:00:54.657334916Z[Etc/UTC]")
public class OffsetAmount   {
  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("offset")
  private Long offset;

  public OffsetAmount amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public OffsetAmount offset(Long offset) {
    this.offset = offset;
    return this;
  }

  /**
   * Номер интервала в списке
   * minimum: 0
   * @return offset
  */
  @ApiModelProperty(required = true, value = "Номер интервала в списке")
  @NotNull

@Min(0L) 
  public Long getOffset() {
    return offset;
  }

  public void setOffset(Long offset) {
    this.offset = offset;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OffsetAmount offsetAmount = (OffsetAmount) o;
    return Objects.equals(this.amount, offsetAmount.amount) &&
        Objects.equals(this.offset, offsetAmount.offset);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, offset);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OffsetAmount {\n");
    
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

