package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.CustomerPayerAllOf;
import dev.vality.anapi.v2.model.Payer;
import dev.vality.anapi.v2.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Многоразовое платежное средство
 */
@ApiModel(description = "Многоразовое платежное средство")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-06-27T12:00:54.657334916Z[Etc/UTC]")
public class CustomerPayer extends Payer  {
  @JsonProperty("customerID")
  private String customerID;

  @JsonProperty("paymentToolToken")
  private String paymentToolToken;

  @JsonProperty("paymentToolDetails")
  private PaymentToolDetails paymentToolDetails;

  public CustomerPayer customerID(String customerID) {
    this.customerID = customerID;
    return this;
  }

  /**
   * Идентификатор плательщика
   * @return customerID
  */
  @ApiModelProperty(required = true, value = "Идентификатор плательщика")
  @NotNull

@Size(min = 1, max = 40) 
  public String getCustomerID() {
    return customerID;
  }

  public void setCustomerID(String customerID) {
    this.customerID = customerID;
  }

  public CustomerPayer paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * Токен платежного средства, предоставленного плательщиком
   * @return paymentToolToken
  */
  @ApiModelProperty(value = "Токен платежного средства, предоставленного плательщиком")

@Size(max = 1000) 
  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public CustomerPayer paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

  /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  */
  @ApiModelProperty(value = "")

  @Valid

  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }

  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomerPayer customerPayer = (CustomerPayer) o;
    return Objects.equals(this.customerID, customerPayer.customerID) &&
        Objects.equals(this.paymentToolToken, customerPayer.paymentToolToken) &&
        Objects.equals(this.paymentToolDetails, customerPayer.paymentToolDetails) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerID, paymentToolToken, paymentToolDetails, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomerPayer {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    customerID: ").append(toIndentedString(customerID)).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

