package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.DefaultLogicError;
import dev.vality.anapi.v2.model.GeneralError;
import dev.vality.anapi.v2.model.InlineResponse20013;
import dev.vality.anapi.v2.model.InlineResponse400;
import dev.vality.anapi.v2.model.InlineResponse4001;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.Report;
import dev.vality.anapi.v2.model.ReportLink;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link ReportsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-06-27T12:00:54.657334916Z[Etc/UTC]")
public interface ReportsApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * POST /reports/{reportID}/cancel : Отменить указанный отчет. Отчеты типа &#x60;provisionOfService&#x60; отменить нельзя
     * Отменить указанный отчет. Отчеты типа &#x60;provisionOfService&#x60; отменить нельзя
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param reportID Идентификатор отчета (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @return Запрос на отмену отчета принят (status code 202)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     *         or Заданный ресурс не найден (status code 404)
     * @see ReportsApi#cancelReport
     */
    default ResponseEntity<Void> cancelReport(String xRequestID,
        String partyID,
        Long reportID,
        String xRequestDeadline) {
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * POST /reports : Сгенерировать отчет с указанным типом по магазину за указанный промежуток времени
     * Сгенерировать отчет с указанным типом по магазину за указанный промежуток времени
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param reportType Тип отчета (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @return Отчет создан (status code 201)
     *         or Ошибочные данные для генерации (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see ReportsApi#createReport
     */
    default ResponseEntity<Report> createReport(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String reportType,
        String xRequestDeadline,
        String shopID) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"reportType\" : \"provisionOfService\", \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"fromTime\" : \"2000-01-23T04:56:07.000+00:00\", \"files\" : [ { \"filename\" : \"filename\", \"id\" : \"id\", \"signatures\" : { \"sha256\" : \"sha256\", \"md5\" : \"md5\" } }, { \"filename\" : \"filename\", \"id\" : \"id\", \"signatures\" : { \"sha256\" : \"sha256\", \"md5\" : \"md5\" } } ], \"id\" : 0, \"shopID\" : \"shopID\", \"partyID\" : \"partyID\", \"toTime\" : \"2000-01-23T04:56:07.000+00:00\", \"status\" : \"pending\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /reports/{reportID}/files/{fileID}/download : Скачать файл
     * Скачать файл
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param reportID Идентификатор отчета (required)
     * @param fileID Идентификатор файла (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @return Download link (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     *         or Заданный ресурс не найден (status code 404)
     * @see ReportsApi#downloadFile
     */
    default ResponseEntity<ReportLink> downloadFile(String xRequestID,
        String partyID,
        Long reportID,
        String fileID,
        String xRequestDeadline) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"url\" : \"url\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /reports/{reportID} : Получить отчет по данному идентификатору
     * Получить отчет по данному идентификатору
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param reportID Идентификатор отчета (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @return Найденный отчет (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     *         or Заданный ресурс не найден (status code 404)
     * @see ReportsApi#getReport
     */
    default ResponseEntity<Report> getReport(String xRequestID,
        String partyID,
        Long reportID,
        String xRequestDeadline) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"reportType\" : \"provisionOfService\", \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"fromTime\" : \"2000-01-23T04:56:07.000+00:00\", \"files\" : [ { \"filename\" : \"filename\", \"id\" : \"id\", \"signatures\" : { \"sha256\" : \"sha256\", \"md5\" : \"md5\" } }, { \"filename\" : \"filename\", \"id\" : \"id\", \"signatures\" : { \"sha256\" : \"sha256\", \"md5\" : \"md5\" } } ], \"id\" : 0, \"shopID\" : \"shopID\", \"partyID\" : \"partyID\", \"toTime\" : \"2000-01-23T04:56:07.000+00:00\", \"status\" : \"pending\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /reports : Получить список отчетов по данному магазину за период
     * Получить список отчетов по данному магазину за период
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param reportTypes Типы отчетов (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param continuationToken  (optional)
     * @return Найденные отчеты (status code 200)
     *         or Ошибочные данные для получения (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see ReportsApi#searchReports
     */
    default ResponseEntity<InlineResponse20013> searchReports(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        Integer limit,
        List<String> reportTypes,
        String xRequestDeadline,
        String shopID,
        String paymentInstitutionRealm,
        String continuationToken) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ { \"reportType\" : \"provisionOfService\", \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"fromTime\" : \"2000-01-23T04:56:07.000+00:00\", \"files\" : [ { \"filename\" : \"filename\", \"id\" : \"id\", \"signatures\" : { \"sha256\" : \"sha256\", \"md5\" : \"md5\" } }, { \"filename\" : \"filename\", \"id\" : \"id\", \"signatures\" : { \"sha256\" : \"sha256\", \"md5\" : \"md5\" } } ], \"id\" : 0, \"shopID\" : \"shopID\", \"partyID\" : \"partyID\", \"toTime\" : \"2000-01-23T04:56:07.000+00:00\", \"status\" : \"pending\" }, { \"reportType\" : \"provisionOfService\", \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"fromTime\" : \"2000-01-23T04:56:07.000+00:00\", \"files\" : [ { \"filename\" : \"filename\", \"id\" : \"id\", \"signatures\" : { \"sha256\" : \"sha256\", \"md5\" : \"md5\" } }, { \"filename\" : \"filename\", \"id\" : \"id\", \"signatures\" : { \"sha256\" : \"sha256\", \"md5\" : \"md5\" } } ], \"id\" : 0, \"shopID\" : \"shopID\", \"partyID\" : \"partyID\", \"toTime\" : \"2000-01-23T04:56:07.000+00:00\", \"status\" : \"pending\" } ], \"continuationToken\" : \"continuationToken\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
