/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.api.RefundsApiDelegate;
import dev.vality.anapi.v2.model.InlineResponse20010;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="refunds", description="the refunds API")
public interface RefundsApi {
    default public RefundsApiDelegate getDelegate() {
        return new RefundsApiDelegate(){};
    }

    @ApiOperation(value="\u041f\u043e\u0438\u0441\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u0432", nickname="searchRefunds", notes="\u041f\u043e\u0438\u0441\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u0432", response=InlineResponse20010.class, authorizations={@Authorization(value="bearer")}, tags={"Search"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u044b", response=InlineResponse20010.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=SearchRequestError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438")})
    @RequestMapping(method={RequestMethod.GET}, value={"/refunds"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<InlineResponse20010> searchRefunds(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) @NotNull @Size(min=1, max=40) @Valid String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime, @NotNull @Min(value=1L) @Max(value=1000L) @ApiParam(value="\u041b\u0438\u043c\u0438\u0442 \u0432\u044b\u0431\u043e\u0440\u043a\u0438", required=true) @Valid @RequestParam(value="limit", required=true) @NotNull @Min(value=1L) @Max(value=1000L) @Valid Integer limit, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430") @Valid @RequestParam(value="shopID", required=false) @Size(min=1, max=40) @Valid String shopID, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0438\u043d\u0432\u043e\u0439\u0441\u0430") @Valid @RequestParam(value="invoiceID", required=false) @Size(min=1, max=40) @Valid String invoiceID, @ApiParam(value="\u0421\u043f\u0438\u0441\u043e\u043a \u0438\u043d\u0432\u043e\u0439\u0441\u043e\u0432") @Valid @RequestParam(value="invoiceIDs", required=false) List<String> invoiceIDs, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0438\u043d\u0432\u043e\u0439\u0441\u0430") @Valid @RequestParam(value="paymentID", required=false) @Size(min=1, max=40) @Valid String paymentID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430") @Valid @RequestParam(value="refundID", required=false) @Size(min=1, max=40) @Valid String refundID, @ApiParam(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430", allowableValues="pending, succeeded, failed") @Valid @RequestParam(value="refundStatus", required=false) String refundStatus, @Size(min=1, max=40) @ApiParam(value="\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440") @Valid @RequestParam(value="externalID", required=false) @Size(min=1, max=40) @Valid String externalID, @ApiParam(value="") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().searchRefunds(xRequestID, partyID, fromTime, toTime, limit, xRequestDeadline, shopID, shopIDs, paymentInstitutionRealm, invoiceID, invoiceIDs, paymentID, refundID, refundStatus, externalID, continuationToken);
    }
}

