package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.PayoutToolDetails;
import dev.vality.anapi.v2.model.PayoutToolDetailsWalletInfoAllOf;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * PayoutToolDetailsWalletInfo
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-07-07T08:12:11.951968249Z[Etc/UTC]")
public class PayoutToolDetailsWalletInfo extends PayoutToolDetails  {
  @JsonProperty("walletID")
  private String walletID;

  public PayoutToolDetailsWalletInfo walletID(String walletID) {
    this.walletID = walletID;
    return this;
  }

  /**
   * Идентификатор кошелька
   * @return walletID
  */
  @ApiModelProperty(required = true, value = "Идентификатор кошелька")
  @NotNull

@Size(min = 1, max = 40) 
  public String getWalletID() {
    return walletID;
  }

  public void setWalletID(String walletID) {
    this.walletID = walletID;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutToolDetailsWalletInfo payoutToolDetailsWalletInfo = (PayoutToolDetailsWalletInfo) o;
    return Objects.equals(this.walletID, payoutToolDetailsWalletInfo.walletID) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(walletID, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutToolDetailsWalletInfo {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    walletID: ").append(toIndentedString(walletID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

