package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * PaymentsToolDistributionResultAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-07-07T08:12:11.951968249Z[Etc/UTC]")
public class PaymentsToolDistributionResultAllOf   {
  @JsonProperty("name")
  private String name;

  @JsonProperty("percents")
  private Double percents;

  public PaymentsToolDistributionResultAllOf name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Название платежного средства
   * @return name
  */
  @ApiModelProperty(required = true, value = "Название платежного средства")
  @NotNull


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public PaymentsToolDistributionResultAllOf percents(Double percents) {
    this.percents = percents;
    return this;
  }

  /**
   * Колличество использования платежного инструмента в процентах
   * minimum: 0
   * @return percents
  */
  @ApiModelProperty(required = true, value = "Колличество использования платежного инструмента в процентах")
  @NotNull

@DecimalMin("0") 
  public Double getPercents() {
    return percents;
  }

  public void setPercents(Double percents) {
    this.percents = percents;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentsToolDistributionResultAllOf paymentsToolDistributionResultAllOf = (PaymentsToolDistributionResultAllOf) o;
    return Objects.equals(this.name, paymentsToolDistributionResultAllOf.name) &&
        Objects.equals(this.percents, paymentsToolDistributionResultAllOf.percents);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, percents);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentsToolDistributionResultAllOf {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    percents: ").append(toIndentedString(percents)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

