/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (5.3.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.DefaultLogicError;
import dev.vality.anapi.v2.model.GeneralError;
import dev.vality.anapi.v2.model.InlineResponse20014;
import dev.vality.anapi.v2.model.InlineResponse400;
import dev.vality.anapi.v2.model.InlineResponse4001;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.Report;
import dev.vality.anapi.v2.model.ReportLink;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-07-07T08:12:11.951968249Z[Etc/UTC]")
@Validated
@Api(value = "reports", description = "the reports API")
public interface ReportsApi {

    default ReportsApiDelegate getDelegate() {
        return new ReportsApiDelegate() {};
    }

    /**
     * POST /reports/{reportID}/cancel : Отменить указанный отчет. Отчеты типа &#x60;provisionOfService&#x60; отменить нельзя
     * Отменить указанный отчет. Отчеты типа &#x60;provisionOfService&#x60; отменить нельзя
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param reportID Идентификатор отчета (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @return Запрос на отмену отчета принят (status code 202)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     *         or Заданный ресурс не найден (status code 404)
     */

    @ApiOperation(value = "Отменить указанный отчет. Отчеты типа `provisionOfService` отменить нельзя", nickname = "cancelReport", notes = "Отменить указанный отчет. Отчеты типа `provisionOfService` отменить нельзя", authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Reports", })
    @ApiResponses(value = { 

        @ApiResponse(code = 202, message = "Запрос на отмену отчета принят"),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации"),

        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/reports/{reportID}/cancel",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<Void> cancelReport(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@ApiParam(value = "Идентификатор отчета", required = true) @PathVariable("reportID") Long reportID

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
) {
        return getDelegate().cancelReport(xRequestID, partyID, reportID, xRequestDeadline);
    }


    /**
     * POST /reports : Сгенерировать отчет с указанным типом по магазину за указанный промежуток времени
     * Сгенерировать отчет с указанным типом по магазину за указанный промежуток времени
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param reportType Тип отчета (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @return Отчет создан (status code 201)
     *         or Ошибочные данные для генерации (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Сгенерировать отчет с указанным типом по магазину за указанный промежуток времени", nickname = "createReport", notes = "Сгенерировать отчет с указанным типом по магазину за указанный промежуток времени", response = Report.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Reports", })
    @ApiResponses(value = { 

        @ApiResponse(code = 201, message = "Отчет создан", response = Report.class),

        @ApiResponse(code = 400, message = "Ошибочные данные для генерации", response = InlineResponse4001.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/reports",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<Report> createReport(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,@NotNull @ApiParam(value = "Тип отчета", required = true, allowableValues = "paymentRegistry") @Valid @RequestParam(value = "reportType", required = true) String reportType

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID

) {
        return getDelegate().createReport(xRequestID, partyID, fromTime, toTime, reportType, xRequestDeadline, shopID);
    }


    /**
     * GET /reports/{reportID}/files/{fileID}/download : Скачать файл
     * Скачать файл
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param reportID Идентификатор отчета (required)
     * @param fileID Идентификатор файла (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @return Download link (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     *         or Заданный ресурс не найден (status code 404)
     */

    @ApiOperation(value = "Скачать файл", nickname = "downloadFile", notes = "Скачать файл", response = ReportLink.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Reports", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Download link", response = ReportLink.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации"),

        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/reports/{reportID}/files/{fileID}/download",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<ReportLink> downloadFile(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@ApiParam(value = "Идентификатор отчета", required = true) @PathVariable("reportID") Long reportID

,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор файла", required = true) @PathVariable("fileID") String fileID

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
) {
        return getDelegate().downloadFile(xRequestID, partyID, reportID, fileID, xRequestDeadline);
    }


    /**
     * GET /reports/{reportID} : Получить отчет по данному идентификатору
     * Получить отчет по данному идентификатору
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param reportID Идентификатор отчета (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @return Найденный отчет (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     *         or Заданный ресурс не найден (status code 404)
     */

    @ApiOperation(value = "Получить отчет по данному идентификатору", nickname = "getReport", notes = "Получить отчет по данному идентификатору", response = Report.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Reports", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Найденный отчет", response = Report.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации"),

        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/reports/{reportID}",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<Report> getReport(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@ApiParam(value = "Идентификатор отчета", required = true) @PathVariable("reportID") Long reportID

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
) {
        return getDelegate().getReport(xRequestID, partyID, reportID, xRequestDeadline);
    }


    /**
     * GET /reports : Получить список отчетов по данному магазину за период
     * Получить список отчетов по данному магазину за период
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param reportTypes Типы отчетов (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param continuationToken  (optional)
     * @return Найденные отчеты (status code 200)
     *         or Ошибочные данные для получения (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получить список отчетов по данному магазину за период", nickname = "searchReports", notes = "Получить список отчетов по данному магазину за период", response = InlineResponse20014.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Reports", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Найденные отчеты", response = InlineResponse20014.class),

        @ApiResponse(code = 400, message = "Ошибочные данные для получения", response = InlineResponse400.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/reports",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse20014> searchReports(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,@NotNull @Min(1) @Max(1000) @ApiParam(value = "Лимит выборки", required = true) @Valid @RequestParam(value = "limit", required = true) Integer limit

,@NotNull @ApiParam(value = "Типы отчетов", required = true, allowableValues = "provisionOfService, paymentRegistry, paymentRegistryByPayout") @Valid @RequestParam(value = "reportTypes", required = true) List<String> reportTypes

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

,@ApiParam(value = "") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken

) {
        return getDelegate().searchReports(xRequestID, partyID, fromTime, toTime, limit, reportTypes, xRequestDeadline, shopID, paymentInstitutionRealm, continuationToken);
    }

}
