package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse20012;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link PayoutsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-07-07T08:12:11.951968249Z[Etc/UTC]")
public interface PayoutsApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * GET /payouts : Поиск выплат
     * Поиск выплат
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param payoutID Идентификатор выплаты (optional)
     * @param payoutToolType  (optional)
     * @param continuationToken  (optional)
     * @return Найденные выплаты (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see PayoutsApi#searchPayouts
     */
    default ResponseEntity<InlineResponse20012> searchPayouts(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        Integer limit,
        String xRequestDeadline,
        String shopID,
        List<String> shopIDs,
        String paymentInstitutionRealm,
        String payoutID,
        String payoutToolType,
        String continuationToken) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ { \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"amount\" : 1, \"payoutToolDetails\" : { \"detailsType\" : \"detailsType\" }, \"metadata\" : { \"payoutDesc\" : \"Custom payout\" }, \"cancellationDetails\" : \"cancellationDetails\", \"fee\" : 0, \"currency\" : \"currency\", \"id\" : \"id\", \"shopID\" : \"shopID\", \"status\" : \"status\" }, { \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"amount\" : 1, \"payoutToolDetails\" : { \"detailsType\" : \"detailsType\" }, \"metadata\" : { \"payoutDesc\" : \"Custom payout\" }, \"cancellationDetails\" : \"cancellationDetails\", \"fee\" : 0, \"currency\" : \"currency\", \"id\" : \"id\", \"shopID\" : \"shopID\", \"status\" : \"status\" } ], \"totalCount\" : 0, \"continuationToken\" : \"continuationToken\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
