/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (5.3.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse2009;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-07-07T08:12:11.951968249Z[Etc/UTC]")
@Validated
@Api(value = "payments", description = "the payments API")
public interface PaymentsApi {

    default PaymentsApiDelegate getDelegate() {
        return new PaymentsApiDelegate() {};
    }

    /**
     * GET /payments : Поиск платежей
     * Поиск платежей
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param invoiceID Идентификатор инвойса (optional)
     * @param invoiceIDs Список инвойсов (optional)
     * @param paymentID Идентификатор платежа в рамках инвойса (optional)
     * @param paymentStatus Статус платежа для поиска (optional)
     * @param paymentFlow Flow платежа (optional)
     * @param paymentMethod Метод оплаты (optional)
     * @param paymentTerminalProvider Провайдер платежного терминала (optional)
     * @param payerEmail Email, указанный при оплате (optional)
     * @param payerIP IP-адрес плательщика (optional)
     * @param payerFingerprint Уникальный отпечаток user agent&#39;а плательщика (optional)
     * @param customerID Идентификатор плательщика (optional)
     * @param first6 Первые 6 цифр номера карты (optional)
     * @param last4 Последние 4 цифры номера карты (optional)
     * @param rrn Retrieval Reference Number (optional)
     * @param approvalCode Authorization Approval Code (optional)
     * @param bankCardTokenProvider  (optional)
     * @param bankCardPaymentSystem  (optional)
     * @param paymentAmountFrom Минимальная сумма платежа (optional)
     * @param paymentAmountTo Максимальная сумма платежа (optional)
     * @param externalID Внешний идентификатор (optional)
     * @param continuationToken  (optional)
     * @return Найденные платежи (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Поиск платежей", nickname = "searchPayments", notes = "Поиск платежей", response = InlineResponse2009.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Search", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Найденные платежи", response = InlineResponse2009.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = SearchRequestError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/payments",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2009> searchPayments(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,@NotNull @Min(1) @Max(1000) @ApiParam(value = "Лимит выборки", required = true) @Valid @RequestParam(value = "limit", required = true) Integer limit

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID

,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор инвойса") @Valid @RequestParam(value = "invoiceID", required = false) String invoiceID

,@ApiParam(value = "Список инвойсов") @Valid @RequestParam(value = "invoiceIDs", required = false) List<String> invoiceIDs

,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор платежа в рамках инвойса") @Valid @RequestParam(value = "paymentID", required = false) String paymentID

,@ApiParam(value = "Статус платежа для поиска", allowableValues = "pending, processed, captured, cancelled, refunded, failed") @Valid @RequestParam(value = "paymentStatus", required = false) String paymentStatus

,@ApiParam(value = "Flow платежа", allowableValues = "instant, hold") @Valid @RequestParam(value = "paymentFlow", required = false) String paymentFlow

,@ApiParam(value = "Метод оплаты", allowableValues = "bankCard, paymentTerminal") @Valid @RequestParam(value = "paymentMethod", required = false) String paymentMethod

,@ApiParam(value = "Провайдер платежного терминала") @Valid @RequestParam(value = "paymentTerminalProvider", required = false) String paymentTerminalProvider

,@Size(max = 100) @javax.validation.constraints.Email@ApiParam(value = "Email, указанный при оплате") @Valid @RequestParam(value = "payerEmail", required = false) String payerEmail

,@Size(max = 45) @ApiParam(value = "IP-адрес плательщика") @Valid @RequestParam(value = "payerIP", required = false) String payerIP

,@Size(max = 1000) @ApiParam(value = "Уникальный отпечаток user agent'а плательщика") @Valid @RequestParam(value = "payerFingerprint", required = false) String payerFingerprint

,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор плательщика") @Valid @RequestParam(value = "customerID", required = false) String customerID

,@Pattern(regexp = "^\\d{6}$") @ApiParam(value = "Первые 6 цифр номера карты") @Valid @RequestParam(value = "first6", required = false) String first6

,@Pattern(regexp = "^\\d{4}$") @ApiParam(value = "Последние 4 цифры номера карты") @Valid @RequestParam(value = "last4", required = false) String last4

,@Pattern(regexp = "^[a-zA-Z0-9]{12}$") @ApiParam(value = "Retrieval Reference Number") @Valid @RequestParam(value = "rrn", required = false) String rrn

,@Size(min = 1, max = 40) @ApiParam(value = "Authorization Approval Code") @Valid @RequestParam(value = "approvalCode", required = false) String approvalCode

,@ApiParam(value = "") @Valid @RequestParam(value = "bankCardTokenProvider", required = false) String bankCardTokenProvider

,@ApiParam(value = "") @Valid @RequestParam(value = "bankCardPaymentSystem", required = false) String bankCardPaymentSystem

,@Min(1L) @ApiParam(value = "Минимальная сумма платежа") @Valid @RequestParam(value = "paymentAmountFrom", required = false) Long paymentAmountFrom

,@Min(1L) @ApiParam(value = "Максимальная сумма платежа") @Valid @RequestParam(value = "paymentAmountTo", required = false) Long paymentAmountTo

,@Size(min = 1, max = 40) @ApiParam(value = "Внешний идентификатор") @Valid @RequestParam(value = "externalID", required = false) String externalID

,@ApiParam(value = "") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken

) {
        return getDelegate().searchPayments(xRequestID, partyID, fromTime, toTime, limit, xRequestDeadline, shopID, shopIDs, excludeShopIDs, paymentInstitutionRealm, invoiceID, invoiceIDs, paymentID, paymentStatus, paymentFlow, paymentMethod, paymentTerminalProvider, payerEmail, payerIP, payerFingerprint, customerID, first6, last4, rrn, approvalCode, bankCardTokenProvider, bankCardPaymentSystem, paymentAmountFrom, paymentAmountTo, externalID, continuationToken);
    }

}
