package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.Payer;
import dev.vality.anapi.v2.model.PaymentFlow;
import dev.vality.anapi.v2.model.TransactionInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * PaymentSearchResultAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
public class PaymentSearchResultAllOf   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("shortID")
  private String shortID;

  @JsonProperty("invoiceID")
  private String invoiceID;

  @JsonProperty("externalID")
  private String externalID;

  @JsonProperty("shopID")
  private String shopID;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("fee")
  private Long fee;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("payer")
  private Payer payer;

  @JsonProperty("flow")
  private PaymentFlow flow;

  @JsonProperty("metadata")
  private Object metadata;

  @JsonProperty("statusChangedAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime statusChangedAt;

  @JsonProperty("transactionInfo")
  private TransactionInfo transactionInfo;

  @JsonProperty("makeRecurrent")
  private Boolean makeRecurrent = false;

  public PaymentSearchResultAllOf id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор платежа
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public PaymentSearchResultAllOf shortID(String shortID) {
    this.shortID = shortID;
    return this;
  }

  /**
   * Cокращенный идентификатор платежа и инвойса (spid)
   * @return shortID
  */
  @ApiModelProperty(value = "Cокращенный идентификатор платежа и инвойса (spid)")


  public String getShortID() {
    return shortID;
  }

  public void setShortID(String shortID) {
    this.shortID = shortID;
  }

  public PaymentSearchResultAllOf invoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
    return this;
  }

  /**
   * Идентификатор инвойса, в рамках которого был создан платеж
   * @return invoiceID
  */
  @ApiModelProperty(required = true, value = "Идентификатор инвойса, в рамках которого был создан платеж")
  @NotNull


  public String getInvoiceID() {
    return invoiceID;
  }

  public void setInvoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
  }

  public PaymentSearchResultAllOf externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Внешний идентификатор
   * @return externalID
  */
  @ApiModelProperty(value = "Внешний идентификатор")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public PaymentSearchResultAllOf shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина, в рамках которого был создан платеж
   * @return shopID
  */
  @ApiModelProperty(value = "Идентификатор магазина, в рамках которого был создан платеж")


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public PaymentSearchResultAllOf createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public PaymentSearchResultAllOf amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public PaymentSearchResultAllOf fee(Long fee) {
    this.fee = fee;
    return this;
  }

  /**
   * Комиссия системы, в минорных денежных единицах
   * minimum: 0
   * @return fee
  */
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах")

@Min(0L) 
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public PaymentSearchResultAllOf currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public PaymentSearchResultAllOf payer(Payer payer) {
    this.payer = payer;
    return this;
  }

  /**
   * Get payer
   * @return payer
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Payer getPayer() {
    return payer;
  }

  public void setPayer(Payer payer) {
    this.payer = payer;
  }

  public PaymentSearchResultAllOf flow(PaymentFlow flow) {
    this.flow = flow;
    return this;
  }

  /**
   * Get flow
   * @return flow
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PaymentFlow getFlow() {
    return flow;
  }

  public void setFlow(PaymentFlow flow) {
    this.flow = flow;
  }

  public PaymentSearchResultAllOf metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Связанные с платежом метаданные
   * @return metadata
  */
  @ApiModelProperty(value = "Связанные с платежом метаданные")


  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public PaymentSearchResultAllOf statusChangedAt(OffsetDateTime statusChangedAt) {
    this.statusChangedAt = statusChangedAt;
    return this;
  }

  /**
   * Дата и время изменения статуса платежа
   * @return statusChangedAt
  */
  @ApiModelProperty(value = "Дата и время изменения статуса платежа")

  @Valid

  public OffsetDateTime getStatusChangedAt() {
    return statusChangedAt;
  }

  public void setStatusChangedAt(OffsetDateTime statusChangedAt) {
    this.statusChangedAt = statusChangedAt;
  }

  public PaymentSearchResultAllOf transactionInfo(TransactionInfo transactionInfo) {
    this.transactionInfo = transactionInfo;
    return this;
  }

  /**
   * Get transactionInfo
   * @return transactionInfo
  */
  @ApiModelProperty(value = "")

  @Valid

  public TransactionInfo getTransactionInfo() {
    return transactionInfo;
  }

  public void setTransactionInfo(TransactionInfo transactionInfo) {
    this.transactionInfo = transactionInfo;
  }

  public PaymentSearchResultAllOf makeRecurrent(Boolean makeRecurrent) {
    this.makeRecurrent = makeRecurrent;
    return this;
  }

  /**
   * Признак создания родительского рекуррентного платежа. Успешно проведеный платеж с этим признаком можно использовать как родительский в других рекуррентных платежах. 
   * @return makeRecurrent
  */
  @ApiModelProperty(value = "Признак создания родительского рекуррентного платежа. Успешно проведеный платеж с этим признаком можно использовать как родительский в других рекуррентных платежах. ")


  public Boolean getMakeRecurrent() {
    return makeRecurrent;
  }

  public void setMakeRecurrent(Boolean makeRecurrent) {
    this.makeRecurrent = makeRecurrent;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentSearchResultAllOf paymentSearchResultAllOf = (PaymentSearchResultAllOf) o;
    return Objects.equals(this.id, paymentSearchResultAllOf.id) &&
        Objects.equals(this.shortID, paymentSearchResultAllOf.shortID) &&
        Objects.equals(this.invoiceID, paymentSearchResultAllOf.invoiceID) &&
        Objects.equals(this.externalID, paymentSearchResultAllOf.externalID) &&
        Objects.equals(this.shopID, paymentSearchResultAllOf.shopID) &&
        Objects.equals(this.createdAt, paymentSearchResultAllOf.createdAt) &&
        Objects.equals(this.amount, paymentSearchResultAllOf.amount) &&
        Objects.equals(this.fee, paymentSearchResultAllOf.fee) &&
        Objects.equals(this.currency, paymentSearchResultAllOf.currency) &&
        Objects.equals(this.payer, paymentSearchResultAllOf.payer) &&
        Objects.equals(this.flow, paymentSearchResultAllOf.flow) &&
        Objects.equals(this.metadata, paymentSearchResultAllOf.metadata) &&
        Objects.equals(this.statusChangedAt, paymentSearchResultAllOf.statusChangedAt) &&
        Objects.equals(this.transactionInfo, paymentSearchResultAllOf.transactionInfo) &&
        Objects.equals(this.makeRecurrent, paymentSearchResultAllOf.makeRecurrent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, shortID, invoiceID, externalID, shopID, createdAt, amount, fee, currency, payer, flow, metadata, statusChangedAt, transactionInfo, makeRecurrent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentSearchResultAllOf {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    shortID: ").append(toIndentedString(shortID)).append("\n");
    sb.append("    invoiceID: ").append(toIndentedString(invoiceID)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    flow: ").append(toIndentedString(flow)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    statusChangedAt: ").append(toIndentedString(statusChangedAt)).append("\n");
    sb.append("    transactionInfo: ").append(toIndentedString(transactionInfo)).append("\n");
    sb.append("    makeRecurrent: ").append(toIndentedString(makeRecurrent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

