package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.anapi.v2.model.InvoiceTemplateAllOf;
import dev.vality.anapi.v2.model.InvoiceTemplateDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * InvoiceTemplate
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
public class InvoiceTemplate   {
  @JsonProperty("eventCreatedAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime eventCreatedAt;

  @JsonProperty("shopID")
  private String shopID;

  @JsonProperty("invoiceTemplateId")
  private String invoiceTemplateId;

  @JsonProperty("invoiceValidUntil")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime invoiceValidUntil;

  @JsonProperty("product")
  private String product;

  @JsonProperty("description")
  private String description;

  @JsonProperty("details")
  private InvoiceTemplateDetails details;

  @JsonProperty("name")
  private String name;

  /**
   * Статус шаблона инвойса
   */
  public enum InvoiceTemplateStatusEnum {
    CREATED("created"),
    
    DELETED("deleted");

    private String value;

    InvoiceTemplateStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InvoiceTemplateStatusEnum fromValue(String value) {
      for (InvoiceTemplateStatusEnum b : InvoiceTemplateStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("invoiceTemplateStatus")
  private InvoiceTemplateStatusEnum invoiceTemplateStatus;

  @JsonProperty("invoiceTemplateCreatedAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime invoiceTemplateCreatedAt;

  public InvoiceTemplate eventCreatedAt(OffsetDateTime eventCreatedAt) {
    this.eventCreatedAt = eventCreatedAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return eventCreatedAt
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getEventCreatedAt() {
    return eventCreatedAt;
  }

  public void setEventCreatedAt(OffsetDateTime eventCreatedAt) {
    this.eventCreatedAt = eventCreatedAt;
  }

  public InvoiceTemplate shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  */
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public InvoiceTemplate invoiceTemplateId(String invoiceTemplateId) {
    this.invoiceTemplateId = invoiceTemplateId;
    return this;
  }

  /**
   * Идентификатор шаблона инвойса
   * @return invoiceTemplateId
  */
  @ApiModelProperty(value = "Идентификатор шаблона инвойса")


  public String getInvoiceTemplateId() {
    return invoiceTemplateId;
  }

  public void setInvoiceTemplateId(String invoiceTemplateId) {
    this.invoiceTemplateId = invoiceTemplateId;
  }

  public InvoiceTemplate invoiceValidUntil(OffsetDateTime invoiceValidUntil) {
    this.invoiceValidUntil = invoiceValidUntil;
    return this;
  }

  /**
   * Дата и время создания
   * @return invoiceValidUntil
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getInvoiceValidUntil() {
    return invoiceValidUntil;
  }

  public void setInvoiceValidUntil(OffsetDateTime invoiceValidUntil) {
    this.invoiceValidUntil = invoiceValidUntil;
  }

  public InvoiceTemplate product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Наименование предлагаемых товаров или услуг
   * @return product
  */
  @ApiModelProperty(required = true, value = "Наименование предлагаемых товаров или услуг")
  @NotNull

@Size(max = 100) 
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public InvoiceTemplate description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Описание предлагаемых товаров или услуг
   * @return description
  */
  @ApiModelProperty(value = "Описание предлагаемых товаров или услуг")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public InvoiceTemplate details(InvoiceTemplateDetails details) {
    this.details = details;
    return this;
  }

  /**
   * Get details
   * @return details
  */
  @ApiModelProperty(value = "")

  @Valid

  public InvoiceTemplateDetails getDetails() {
    return details;
  }

  public void setDetails(InvoiceTemplateDetails details) {
    this.details = details;
  }

  public InvoiceTemplate name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Имя шаблона инвойса
   * @return name
  */
  @ApiModelProperty(value = "Имя шаблона инвойса")


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public InvoiceTemplate invoiceTemplateStatus(InvoiceTemplateStatusEnum invoiceTemplateStatus) {
    this.invoiceTemplateStatus = invoiceTemplateStatus;
    return this;
  }

  /**
   * Статус шаблона инвойса
   * @return invoiceTemplateStatus
  */
  @ApiModelProperty(value = "Статус шаблона инвойса")


  public InvoiceTemplateStatusEnum getInvoiceTemplateStatus() {
    return invoiceTemplateStatus;
  }

  public void setInvoiceTemplateStatus(InvoiceTemplateStatusEnum invoiceTemplateStatus) {
    this.invoiceTemplateStatus = invoiceTemplateStatus;
  }

  public InvoiceTemplate invoiceTemplateCreatedAt(OffsetDateTime invoiceTemplateCreatedAt) {
    this.invoiceTemplateCreatedAt = invoiceTemplateCreatedAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return invoiceTemplateCreatedAt
  */
  @ApiModelProperty(value = "Дата и время создания")

  @Valid

  public OffsetDateTime getInvoiceTemplateCreatedAt() {
    return invoiceTemplateCreatedAt;
  }

  public void setInvoiceTemplateCreatedAt(OffsetDateTime invoiceTemplateCreatedAt) {
    this.invoiceTemplateCreatedAt = invoiceTemplateCreatedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceTemplate invoiceTemplate = (InvoiceTemplate) o;
    return Objects.equals(this.eventCreatedAt, invoiceTemplate.eventCreatedAt) &&
        Objects.equals(this.shopID, invoiceTemplate.shopID) &&
        Objects.equals(this.invoiceTemplateId, invoiceTemplate.invoiceTemplateId) &&
        Objects.equals(this.invoiceValidUntil, invoiceTemplate.invoiceValidUntil) &&
        Objects.equals(this.product, invoiceTemplate.product) &&
        Objects.equals(this.description, invoiceTemplate.description) &&
        Objects.equals(this.details, invoiceTemplate.details) &&
        Objects.equals(this.name, invoiceTemplate.name) &&
        Objects.equals(this.invoiceTemplateStatus, invoiceTemplate.invoiceTemplateStatus) &&
        Objects.equals(this.invoiceTemplateCreatedAt, invoiceTemplate.invoiceTemplateCreatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventCreatedAt, shopID, invoiceTemplateId, invoiceValidUntil, product, description, details, name, invoiceTemplateStatus, invoiceTemplateCreatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceTemplate {\n");
    
    sb.append("    eventCreatedAt: ").append(toIndentedString(eventCreatedAt)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    invoiceTemplateId: ").append(toIndentedString(invoiceTemplateId)).append("\n");
    sb.append("    invoiceValidUntil: ").append(toIndentedString(invoiceValidUntil)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    invoiceTemplateStatus: ").append(toIndentedString(invoiceTemplateStatus)).append("\n");
    sb.append("    invoiceTemplateCreatedAt: ").append(toIndentedString(invoiceTemplateCreatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

