package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Налог на добавленную стоимость в юрисдикции РФ
 */
@ApiModel(description = "Налог на добавленную стоимость в юрисдикции РФ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
public class InvoiceLineTaxVATAllOf   {
  /**
   * Ставка налога
   */
  public enum RateEnum {
    _0_("0%"),
    
    _10_("10%"),
    
    _18_("18%"),
    
    _20_("20%"),
    
    _10_110("10/110"),
    
    _18_118("18/118"),
    
    _20_120("20/120");

    private String value;

    RateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateEnum fromValue(String value) {
      for (RateEnum b : RateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("rate")
  private RateEnum rate;

  public InvoiceLineTaxVATAllOf rate(RateEnum rate) {
    this.rate = rate;
    return this;
  }

  /**
   * Ставка налога
   * @return rate
  */
  @ApiModelProperty(required = true, value = "Ставка налога")
  @NotNull


  public RateEnum getRate() {
    return rate;
  }

  public void setRate(RateEnum rate) {
    this.rate = rate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceLineTaxVATAllOf invoiceLineTaxVATAllOf = (InvoiceLineTaxVATAllOf) o;
    return Objects.equals(this.rate, invoiceLineTaxVATAllOf.rate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceLineTaxVATAllOf {\n");
    
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

