package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.InvoiceLine;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * InvoiceAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
public class InvoiceAllOf   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("externalID")
  private String externalID;

  @JsonProperty("shopID")
  private String shopID;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("dueDate")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime dueDate;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("product")
  private String product;

  @JsonProperty("description")
  private String description;

  @JsonProperty("invoiceTemplateID")
  private String invoiceTemplateID;

  @JsonProperty("cart")
  @Valid
  private List<InvoiceLine> cart = null;

  @JsonProperty("metadata")
  private Object metadata;

  public InvoiceAllOf id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор инвойса
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public InvoiceAllOf externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Внешний идентификатор
   * @return externalID
  */
  @ApiModelProperty(value = "Внешний идентификатор")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public InvoiceAllOf shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  */
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public InvoiceAllOf createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public InvoiceAllOf dueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Дата и время окончания действия
   * @return dueDate
  */
  @ApiModelProperty(required = true, value = "Дата и время окончания действия")
  @NotNull

  @Valid

  public OffsetDateTime getDueDate() {
    return dueDate;
  }

  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
  }

  public InvoiceAllOf amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public InvoiceAllOf currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public InvoiceAllOf product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Наименование предлагаемых товаров или услуг
   * @return product
  */
  @ApiModelProperty(required = true, value = "Наименование предлагаемых товаров или услуг")
  @NotNull

@Size(max = 100) 
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public InvoiceAllOf description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Описание предлагаемых товаров или услуг
   * @return description
  */
  @ApiModelProperty(value = "Описание предлагаемых товаров или услуг")

@Size(max = 1000) 
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public InvoiceAllOf invoiceTemplateID(String invoiceTemplateID) {
    this.invoiceTemplateID = invoiceTemplateID;
    return this;
  }

  /**
   * Идентификатор шаблона (для инвойсов, созданных по шаблону).
   * @return invoiceTemplateID
  */
  @ApiModelProperty(value = "Идентификатор шаблона (для инвойсов, созданных по шаблону).")


  public String getInvoiceTemplateID() {
    return invoiceTemplateID;
  }

  public void setInvoiceTemplateID(String invoiceTemplateID) {
    this.invoiceTemplateID = invoiceTemplateID;
  }

  public InvoiceAllOf cart(List<InvoiceLine> cart) {
    this.cart = cart;
    return this;
  }

  public InvoiceAllOf addCartItem(InvoiceLine cartItem) {
    if (this.cart == null) {
      this.cart = new ArrayList<>();
    }
    this.cart.add(cartItem);
    return this;
  }

  /**
   * Корзина с набором позиций продаваемых товаров или услуг 
   * @return cart
  */
  @ApiModelProperty(value = "Корзина с набором позиций продаваемых товаров или услуг ")

  @Valid
@Size(min = 1, max = 100) 
  public List<InvoiceLine> getCart() {
    return cart;
  }

  public void setCart(List<InvoiceLine> cart) {
    this.cart = cart;
  }

  public InvoiceAllOf metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Связанные с инвойсом метаданные
   * @return metadata
  */
  @ApiModelProperty(required = true, value = "Связанные с инвойсом метаданные")
  @NotNull


  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceAllOf invoiceAllOf = (InvoiceAllOf) o;
    return Objects.equals(this.id, invoiceAllOf.id) &&
        Objects.equals(this.externalID, invoiceAllOf.externalID) &&
        Objects.equals(this.shopID, invoiceAllOf.shopID) &&
        Objects.equals(this.createdAt, invoiceAllOf.createdAt) &&
        Objects.equals(this.dueDate, invoiceAllOf.dueDate) &&
        Objects.equals(this.amount, invoiceAllOf.amount) &&
        Objects.equals(this.currency, invoiceAllOf.currency) &&
        Objects.equals(this.product, invoiceAllOf.product) &&
        Objects.equals(this.description, invoiceAllOf.description) &&
        Objects.equals(this.invoiceTemplateID, invoiceAllOf.invoiceTemplateID) &&
        Objects.equals(this.cart, invoiceAllOf.cart) &&
        Objects.equals(this.metadata, invoiceAllOf.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, externalID, shopID, createdAt, dueDate, amount, currency, product, description, invoiceTemplateID, cart, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceAllOf {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    invoiceTemplateID: ").append(toIndentedString(invoiceTemplateID)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

