package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.ChargebackReason;
import dev.vality.anapi.v2.model.ChargebackStage;
import dev.vality.anapi.v2.model.ChargebackStatus;
import dev.vality.anapi.v2.model.Content;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Chargeback
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
public class Chargeback   {
  @JsonProperty("invoiceId")
  private String invoiceId;

  @JsonProperty("paymentId")
  private String paymentId;

  @JsonProperty("chargebackId")
  private String chargebackId;

  @JsonProperty("externalId")
  private String externalId;

  @JsonProperty("shopID")
  private String shopID;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("levyAmount")
  private Long levyAmount;

  @JsonProperty("levyCurrency")
  private String levyCurrency;

  @JsonProperty("bodyAmount")
  private Long bodyAmount;

  @JsonProperty("bodyCurrency")
  private String bodyCurrency;

  @JsonProperty("fee")
  private Long fee;

  @JsonProperty("providerFee")
  private Long providerFee;

  @JsonProperty("externalFee")
  private Long externalFee;

  @JsonProperty("status")
  private ChargebackStatus status;

  @JsonProperty("stage")
  private ChargebackStage stage;

  @JsonProperty("chargebackReason")
  private ChargebackReason chargebackReason;

  @JsonProperty("content")
  private Content content;

  public Chargeback invoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

  /**
   * Идентификатор инвойса
   * @return invoiceId
  */
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  @NotNull


  public String getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
  }

  public Chargeback paymentId(String paymentId) {
    this.paymentId = paymentId;
    return this;
  }

  /**
   * Идентификатор платежа
   * @return paymentId
  */
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  @NotNull


  public String getPaymentId() {
    return paymentId;
  }

  public void setPaymentId(String paymentId) {
    this.paymentId = paymentId;
  }

  public Chargeback chargebackId(String chargebackId) {
    this.chargebackId = chargebackId;
    return this;
  }

  /**
   * Идентификатор чарджбэка
   * @return chargebackId
  */
  @ApiModelProperty(required = true, value = "Идентификатор чарджбэка")
  @NotNull


  public String getChargebackId() {
    return chargebackId;
  }

  public void setChargebackId(String chargebackId) {
    this.chargebackId = chargebackId;
  }

  public Chargeback externalId(String externalId) {
    this.externalId = externalId;
    return this;
  }

  /**
   * Внешний идентификатор
   * @return externalId
  */
  @ApiModelProperty(value = "Внешний идентификатор")


  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public Chargeback shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  */
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Chargeback createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Chargeback levyAmount(Long levyAmount) {
    this.levyAmount = levyAmount;
    return this;
  }

  /**
   * Сумма списываемых средств у чарджбека
   * minimum: 1
   * @return levyAmount
  */
  @ApiModelProperty(required = true, value = "Сумма списываемых средств у чарджбека")
  @NotNull

@Min(1L) 
  public Long getLevyAmount() {
    return levyAmount;
  }

  public void setLevyAmount(Long levyAmount) {
    this.levyAmount = levyAmount;
  }

  public Chargeback levyCurrency(String levyCurrency) {
    this.levyCurrency = levyCurrency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return levyCurrency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getLevyCurrency() {
    return levyCurrency;
  }

  public void setLevyCurrency(String levyCurrency) {
    this.levyCurrency = levyCurrency;
  }

  public Chargeback bodyAmount(Long bodyAmount) {
    this.bodyAmount = bodyAmount;
    return this;
  }

  /**
   * Сумма чарджбэка
   * minimum: 1
   * @return bodyAmount
  */
  @ApiModelProperty(required = true, value = "Сумма чарджбэка")
  @NotNull

@Min(1L) 
  public Long getBodyAmount() {
    return bodyAmount;
  }

  public void setBodyAmount(Long bodyAmount) {
    this.bodyAmount = bodyAmount;
  }

  public Chargeback bodyCurrency(String bodyCurrency) {
    this.bodyCurrency = bodyCurrency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return bodyCurrency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getBodyCurrency() {
    return bodyCurrency;
  }

  public void setBodyCurrency(String bodyCurrency) {
    this.bodyCurrency = bodyCurrency;
  }

  public Chargeback fee(Long fee) {
    this.fee = fee;
    return this;
  }

  /**
   * Комиссия системы, в минорных денежных единицах
   * minimum: 0
   * @return fee
  */
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах")

@Min(0L) 
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public Chargeback providerFee(Long providerFee) {
    this.providerFee = providerFee;
    return this;
  }

  /**
   * Комиссия провайдера, в минорных денежных единицах
   * minimum: 0
   * @return providerFee
  */
  @ApiModelProperty(value = "Комиссия провайдера, в минорных денежных единицах")

@Min(0L) 
  public Long getProviderFee() {
    return providerFee;
  }

  public void setProviderFee(Long providerFee) {
    this.providerFee = providerFee;
  }

  public Chargeback externalFee(Long externalFee) {
    this.externalFee = externalFee;
    return this;
  }

  /**
   * Комиссия внешней системы системы, в минорных денежных единицах
   * minimum: 0
   * @return externalFee
  */
  @ApiModelProperty(value = "Комиссия внешней системы системы, в минорных денежных единицах")

@Min(0L) 
  public Long getExternalFee() {
    return externalFee;
  }

  public void setExternalFee(Long externalFee) {
    this.externalFee = externalFee;
  }

  public Chargeback status(ChargebackStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @ApiModelProperty(value = "")

  @Valid

  public ChargebackStatus getStatus() {
    return status;
  }

  public void setStatus(ChargebackStatus status) {
    this.status = status;
  }

  public Chargeback stage(ChargebackStage stage) {
    this.stage = stage;
    return this;
  }

  /**
   * Get stage
   * @return stage
  */
  @ApiModelProperty(value = "")

  @Valid

  public ChargebackStage getStage() {
    return stage;
  }

  public void setStage(ChargebackStage stage) {
    this.stage = stage;
  }

  public Chargeback chargebackReason(ChargebackReason chargebackReason) {
    this.chargebackReason = chargebackReason;
    return this;
  }

  /**
   * Get chargebackReason
   * @return chargebackReason
  */
  @ApiModelProperty(value = "")

  @Valid

  public ChargebackReason getChargebackReason() {
    return chargebackReason;
  }

  public void setChargebackReason(ChargebackReason chargebackReason) {
    this.chargebackReason = chargebackReason;
  }

  public Chargeback content(Content content) {
    this.content = content;
    return this;
  }

  /**
   * Get content
   * @return content
  */
  @ApiModelProperty(value = "")

  @Valid

  public Content getContent() {
    return content;
  }

  public void setContent(Content content) {
    this.content = content;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Chargeback chargeback = (Chargeback) o;
    return Objects.equals(this.invoiceId, chargeback.invoiceId) &&
        Objects.equals(this.paymentId, chargeback.paymentId) &&
        Objects.equals(this.chargebackId, chargeback.chargebackId) &&
        Objects.equals(this.externalId, chargeback.externalId) &&
        Objects.equals(this.shopID, chargeback.shopID) &&
        Objects.equals(this.createdAt, chargeback.createdAt) &&
        Objects.equals(this.levyAmount, chargeback.levyAmount) &&
        Objects.equals(this.levyCurrency, chargeback.levyCurrency) &&
        Objects.equals(this.bodyAmount, chargeback.bodyAmount) &&
        Objects.equals(this.bodyCurrency, chargeback.bodyCurrency) &&
        Objects.equals(this.fee, chargeback.fee) &&
        Objects.equals(this.providerFee, chargeback.providerFee) &&
        Objects.equals(this.externalFee, chargeback.externalFee) &&
        Objects.equals(this.status, chargeback.status) &&
        Objects.equals(this.stage, chargeback.stage) &&
        Objects.equals(this.chargebackReason, chargeback.chargebackReason) &&
        Objects.equals(this.content, chargeback.content);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, paymentId, chargebackId, externalId, shopID, createdAt, levyAmount, levyCurrency, bodyAmount, bodyCurrency, fee, providerFee, externalFee, status, stage, chargebackReason, content);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Chargeback {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    paymentId: ").append(toIndentedString(paymentId)).append("\n");
    sb.append("    chargebackId: ").append(toIndentedString(chargebackId)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    levyAmount: ").append(toIndentedString(levyAmount)).append("\n");
    sb.append("    levyCurrency: ").append(toIndentedString(levyCurrency)).append("\n");
    sb.append("    bodyAmount: ").append(toIndentedString(bodyAmount)).append("\n");
    sb.append("    bodyCurrency: ").append(toIndentedString(bodyCurrency)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    providerFee: ").append(toIndentedString(providerFee)).append("\n");
    sb.append("    externalFee: ").append(toIndentedString(externalFee)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    stage: ").append(toIndentedString(stage)).append("\n");
    sb.append("    chargebackReason: ").append(toIndentedString(chargebackReason)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

