package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse2008;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link InvoicesApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
public interface InvoicesApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * GET /invoices : Поиск инвойсов
     * Поиск инвойсов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param invoiceID Идентификатор инвойса (optional)
     * @param invoiceIDs Список инвойсов (optional)
     * @param invoiceStatus Статус инвойса для поиска (optional)
     * @param invoiceAmountFrom Минимальная сумма инвойса (optional)
     * @param invoiceAmountTo Максимальная сумма инвойса (optional)
     * @param externalID Внешний идентификатор (optional)
     * @param continuationToken  (optional)
     * @return Найденные инвойсы (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see InvoicesApi#searchInvoices
     */
    default ResponseEntity<InlineResponse2008> searchInvoices(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        Integer limit,
        String xRequestDeadline,
        String shopID,
        List<String> shopIDs,
        String paymentInstitutionRealm,
        String invoiceID,
        List<String> invoiceIDs,
        String invoiceStatus,
        Long invoiceAmountFrom,
        Long invoiceAmountTo,
        String externalID,
        String continuationToken) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ], \"continuationToken\" : \"continuationToken\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
