package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse20011;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link ChargebacksApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
public interface ChargebacksApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * GET /chargebacks : Поиск чарджбэков
     * Поиск чарджбэков
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param invoiceID Идентификатор инвойса (optional)
     * @param paymentID Идентификатор платежа в рамках инвойса (optional)
     * @param chargebackID Идентификатор чарджбэка (optional)
     * @param chargebackStatuses Статусы чарджбэков (optional)
     * @param chargebackStages Этапы чарджбэков (optional)
     * @param chargebackCategories Категории чарджбэков (optional)
     * @param continuationToken  (optional)
     * @return Найденные чарджбэки (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see ChargebacksApi#searchChargebacks
     */
    default ResponseEntity<InlineResponse20011> searchChargebacks(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        Integer limit,
        String xRequestDeadline,
        String shopID,
        List<String> shopIDs,
        String paymentInstitutionRealm,
        String invoiceID,
        String paymentID,
        String chargebackID,
        List<String> chargebackStatuses,
        List<String> chargebackStages,
        List<String> chargebackCategories,
        String continuationToken) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ { \"chargebackId\" : \"chargebackId\", \"levyAmount\" : 1, \"providerFee\" : 0, \"fee\" : 0, \"levyCurrency\" : \"levyCurrency\", \"externalId\" : \"externalId\", \"bodyAmount\" : 1, \"bodyCurrency\" : \"bodyCurrency\", \"content\" : { \"data\" : \"data\", \"type\" : \"type\" }, \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"paymentId\" : \"paymentId\", \"chargebackReason\" : { \"code\" : \"code\" }, \"invoiceId\" : \"invoiceId\", \"shopID\" : \"shopID\", \"externalFee\" : 0 }, { \"chargebackId\" : \"chargebackId\", \"levyAmount\" : 1, \"providerFee\" : 0, \"fee\" : 0, \"levyCurrency\" : \"levyCurrency\", \"externalId\" : \"externalId\", \"bodyAmount\" : 1, \"bodyCurrency\" : \"bodyCurrency\", \"content\" : { \"data\" : \"data\", \"type\" : \"type\" }, \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\", \"paymentId\" : \"paymentId\", \"chargebackReason\" : { \"code\" : \"code\" }, \"invoiceId\" : \"invoiceId\", \"shopID\" : \"shopID\", \"externalFee\" : 0 } ], \"totalCount\" : 0, \"continuationToken\" : \"continuationToken\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
