package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.DefaultLogicError;
import dev.vality.anapi.v2.model.InlineResponse200;
import dev.vality.anapi.v2.model.InlineResponse2001;
import dev.vality.anapi.v2.model.InlineResponse2002;
import dev.vality.anapi.v2.model.InlineResponse2003;
import dev.vality.anapi.v2.model.InlineResponse2004;
import dev.vality.anapi.v2.model.InlineResponse2005;
import dev.vality.anapi.v2.model.InlineResponse2006;
import dev.vality.anapi.v2.model.InlineResponse2007;
import java.time.OffsetDateTime;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link AnalyticsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
public interface AnalyticsApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * GET /analytics/payments/average : Получение среднего размера платежа с группировкой по валютам
     * Получение среднего размера платежа с группировкой по валютам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Средний размер платежа с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getAveragePayment
     */
    default ResponseEntity<InlineResponse200> getAveragePayment(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/crediting/amount : Получение списка зачислений с группировкой по валютам для ЛК
     * Получение списка зачислений с группировкой по валютам для ЛК
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список зачислений с группировкой по валютам для ЛК (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getCreditingsAmount
     */
    default ResponseEntity<InlineResponse200> getCreditingsAmount(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/balances/current : Получение текущего баланса по магазину
     * Получение текущего баланса по магазину
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список оборотов с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getCurrentBalances
     */
    default ResponseEntity<InlineResponse200> getCurrentBalances(String xRequestID,
        String partyID,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/balances/current-shop-balances : Получение текущего баланса с группировкой по магазинам
     * Получение текущего баланса с группировкой по магазинам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список балансов с группировкой по магазинам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getCurrentShopBalances
     */
    default ResponseEntity<InlineResponse2007> getCurrentShopBalances(String xRequestID,
        String partyID,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ { \"amountResults\" : [ null, null ], \"id\" : \"id\" }, { \"amountResults\" : [ null, null ], \"id\" : \"id\" } ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/payments/amount : Получение списка оборотов с группировкой по валютам
     * Получение списка оборотов с группировкой по валютам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список оборотов с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getPaymentsAmount
     */
    default ResponseEntity<InlineResponse200> getPaymentsAmount(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/payments/count : Получение количества платежей с группировкой по валютам
     * Получение количества платежей с группировкой по валютам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Среднее количество платежей с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getPaymentsCount
     */
    default ResponseEntity<InlineResponse2001> getPaymentsCount(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/payments/errors : Получение распределения ошибок
     * Получение распределения ошибок
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Распределение ошибок (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getPaymentsErrorDistribution
     */
    default ResponseEntity<InlineResponse2002> getPaymentsErrorDistribution(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/payments/split-amount : Получение списка оборотов с группировкой по валютам и разделенные по временным интервалам
     * Получение списка оборотов с группировкой по валютам и разделенные по временным интервалам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param splitUnit Единица времени сегмента разбиения (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список оборотов с группировкой по валютам и разделенные по временным интервалам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getPaymentsSplitAmount
     */
    default ResponseEntity<InlineResponse2003> getPaymentsSplitAmount(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String splitUnit,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ { \"currency\" : \"currency\", \"offsetAmounts\" : [ { \"amount\" : 1, \"offset\" : 0 }, { \"amount\" : 1, \"offset\" : 0 } ] }, { \"currency\" : \"currency\", \"offsetAmounts\" : [ { \"amount\" : 1, \"offset\" : 0 }, { \"amount\" : 1, \"offset\" : 0 } ] } ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/payments/split-count : Получение количества платежей с группировкой по валютам и статусам, разделенного по временным интервалам
     * Получение количества платежей с группировкой по валютам и статусам, разделенного по временным интервалам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param splitUnit Единица времени сегмента разбиения (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Количество платежей с группировкой по валютам и статусам, разделенное по временным интервалам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getPaymentsSplitCount
     */
    default ResponseEntity<InlineResponse2004> getPaymentsSplitCount(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String splitUnit,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ { \"statusOffsetCounts\" : [ { \"status\" : \"pending\", \"offsetCount\" : [ null, null ] }, { \"status\" : \"pending\", \"offsetCount\" : [ null, null ] } ], \"currency\" : \"currency\" }, { \"statusOffsetCounts\" : [ { \"status\" : \"pending\", \"offsetCount\" : [ null, null ] }, { \"status\" : \"pending\", \"offsetCount\" : [ null, null ] } ], \"currency\" : \"currency\" } ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/payments/sub-errors : Получение распределения ошибок с подошибками
     * Получение распределения ошибок с подошибками
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Распределение ошибок с подошибками (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getPaymentsSubErrorDistribution
     */
    default ResponseEntity<InlineResponse2005> getPaymentsSubErrorDistribution(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/payments-tool : Получение распределения использования платежных инструментов
     * Получение распределения использования платежных инструментов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Распределение использования платежных инструментов (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getPaymentsToolDistribution
     */
    default ResponseEntity<InlineResponse2006> getPaymentsToolDistribution(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

    /**
     * GET /analytics/refunds/amount : Получение списка возвратов с группировкой по валютам
     * Получение списка возвратов с группировкой по валютам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список возвратов с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see AnalyticsApi#getRefundsAmount
     */
    default ResponseEntity<InlineResponse200> getRefundsAmount(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        String xRequestDeadline,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ] }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
