/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (5.3.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.DefaultLogicError;
import dev.vality.anapi.v2.model.InlineResponse200;
import dev.vality.anapi.v2.model.InlineResponse2001;
import dev.vality.anapi.v2.model.InlineResponse2002;
import dev.vality.anapi.v2.model.InlineResponse2003;
import dev.vality.anapi.v2.model.InlineResponse2004;
import dev.vality.anapi.v2.model.InlineResponse2005;
import dev.vality.anapi.v2.model.InlineResponse2006;
import dev.vality.anapi.v2.model.InlineResponse2007;
import java.time.OffsetDateTime;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-06-26T11:05:19.018610057Z[Etc/UTC]")
@Validated
@Api(value = "analytics", description = "the analytics API")
public interface AnalyticsApi {

    default AnalyticsApiDelegate getDelegate() {
        return new AnalyticsApiDelegate() {};
    }

    /**
     * GET /analytics/payments/average : Получение среднего размера платежа с группировкой по валютам
     * Получение среднего размера платежа с группировкой по валютам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Средний размер платежа с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение среднего размера платежа с группировкой по валютам", nickname = "getAveragePayment", notes = "Получение среднего размера платежа с группировкой по валютам", response = InlineResponse200.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Средний размер платежа с группировкой по валютам", response = InlineResponse200.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/payments/average",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse200> getAveragePayment(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getAveragePayment(xRequestID, partyID, fromTime, toTime, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/crediting/amount : Получение списка зачислений с группировкой по валютам для ЛК
     * Получение списка зачислений с группировкой по валютам для ЛК
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список зачислений с группировкой по валютам для ЛК (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение списка зачислений с группировкой по валютам для ЛК", nickname = "getCreditingsAmount", notes = "Получение списка зачислений с группировкой по валютам для ЛК", response = InlineResponse200.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Список зачислений с группировкой по валютам для ЛК", response = InlineResponse200.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/crediting/amount",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse200> getCreditingsAmount(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getCreditingsAmount(xRequestID, partyID, fromTime, toTime, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/balances/current : Получение текущего баланса по магазину
     * Получение текущего баланса по магазину
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список оборотов с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение текущего баланса по магазину", nickname = "getCurrentBalances", notes = "Получение текущего баланса по магазину", response = InlineResponse200.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Список оборотов с группировкой по валютам", response = InlineResponse200.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/balances/current",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse200> getCurrentBalances(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getCurrentBalances(xRequestID, partyID, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/balances/current-shop-balances : Получение текущего баланса с группировкой по магазинам
     * Получение текущего баланса с группировкой по магазинам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список балансов с группировкой по магазинам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение текущего баланса с группировкой по магазинам", nickname = "getCurrentShopBalances", notes = "Получение текущего баланса с группировкой по магазинам", response = InlineResponse2007.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Список балансов с группировкой по магазинам", response = InlineResponse2007.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/balances/current-shop-balances",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2007> getCurrentShopBalances(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getCurrentShopBalances(xRequestID, partyID, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/payments/amount : Получение списка оборотов с группировкой по валютам
     * Получение списка оборотов с группировкой по валютам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список оборотов с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение списка оборотов с группировкой по валютам", nickname = "getPaymentsAmount", notes = "Получение списка оборотов с группировкой по валютам", response = InlineResponse200.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Список оборотов с группировкой по валютам", response = InlineResponse200.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/payments/amount",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse200> getPaymentsAmount(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getPaymentsAmount(xRequestID, partyID, fromTime, toTime, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/payments/count : Получение количества платежей с группировкой по валютам
     * Получение количества платежей с группировкой по валютам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Среднее количество платежей с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение количества платежей с группировкой по валютам", nickname = "getPaymentsCount", notes = "Получение количества платежей с группировкой по валютам", response = InlineResponse2001.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Среднее количество платежей с группировкой по валютам", response = InlineResponse2001.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/payments/count",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2001> getPaymentsCount(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getPaymentsCount(xRequestID, partyID, fromTime, toTime, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/payments/errors : Получение распределения ошибок
     * Получение распределения ошибок
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Распределение ошибок (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение распределения ошибок", nickname = "getPaymentsErrorDistribution", notes = "Получение распределения ошибок", response = InlineResponse2002.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Распределение ошибок", response = InlineResponse2002.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/payments/errors",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2002> getPaymentsErrorDistribution(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getPaymentsErrorDistribution(xRequestID, partyID, fromTime, toTime, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/payments/split-amount : Получение списка оборотов с группировкой по валютам и разделенные по временным интервалам
     * Получение списка оборотов с группировкой по валютам и разделенные по временным интервалам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param splitUnit Единица времени сегмента разбиения (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список оборотов с группировкой по валютам и разделенные по временным интервалам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение списка оборотов с группировкой по валютам и разделенные по временным интервалам", nickname = "getPaymentsSplitAmount", notes = "Получение списка оборотов с группировкой по валютам и разделенные по временным интервалам", response = InlineResponse2003.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Список оборотов с группировкой по валютам и разделенные по временным интервалам", response = InlineResponse2003.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/payments/split-amount",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2003> getPaymentsSplitAmount(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,@NotNull @ApiParam(value = "Единица времени сегмента разбиения", required = true, allowableValues = "minute, hour, day, week, month, year") @Valid @RequestParam(value = "splitUnit", required = true) String splitUnit

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getPaymentsSplitAmount(xRequestID, partyID, fromTime, toTime, splitUnit, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/payments/split-count : Получение количества платежей с группировкой по валютам и статусам, разделенного по временным интервалам
     * Получение количества платежей с группировкой по валютам и статусам, разделенного по временным интервалам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param splitUnit Единица времени сегмента разбиения (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Количество платежей с группировкой по валютам и статусам, разделенное по временным интервалам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение количества платежей с группировкой по валютам и статусам, разделенного по временным интервалам", nickname = "getPaymentsSplitCount", notes = "Получение количества платежей с группировкой по валютам и статусам, разделенного по временным интервалам", response = InlineResponse2004.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Количество платежей с группировкой по валютам и статусам, разделенное по временным интервалам", response = InlineResponse2004.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/payments/split-count",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2004> getPaymentsSplitCount(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,@NotNull @ApiParam(value = "Единица времени сегмента разбиения", required = true, allowableValues = "minute, hour, day, week, month, year") @Valid @RequestParam(value = "splitUnit", required = true) String splitUnit

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getPaymentsSplitCount(xRequestID, partyID, fromTime, toTime, splitUnit, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/payments/sub-errors : Получение распределения ошибок с подошибками
     * Получение распределения ошибок с подошибками
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Распределение ошибок с подошибками (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение распределения ошибок с подошибками", nickname = "getPaymentsSubErrorDistribution", notes = "Получение распределения ошибок с подошибками", response = InlineResponse2005.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Распределение ошибок с подошибками", response = InlineResponse2005.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/payments/sub-errors",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2005> getPaymentsSubErrorDistribution(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getPaymentsSubErrorDistribution(xRequestID, partyID, fromTime, toTime, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/payments-tool : Получение распределения использования платежных инструментов
     * Получение распределения использования платежных инструментов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Распределение использования платежных инструментов (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение распределения использования платежных инструментов", nickname = "getPaymentsToolDistribution", notes = "Получение распределения использования платежных инструментов", response = InlineResponse2006.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Распределение использования платежных инструментов", response = InlineResponse2006.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/payments-tool",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2006> getPaymentsToolDistribution(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getPaymentsToolDistribution(xRequestID, partyID, fromTime, toTime, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }


    /**
     * GET /analytics/refunds/amount : Получение списка возвратов с группировкой по валютам
     * Получение списка возвратов с группировкой по валютам
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @return Список возвратов с группировкой по валютам (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Получение списка возвратов с группировкой по валютам", nickname = "getRefundsAmount", notes = "Получение списка возвратов с группировкой по валютам", response = InlineResponse200.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Analytics", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Список возвратов с группировкой по валютам", response = InlineResponse200.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/analytics/refunds/amount",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse200> getRefundsAmount(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Идентификаторы магазинов, исключаемых из запроса") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

) {
        return getDelegate().getRefundsAmount(xRequestID, partyID, fromTime, toTime, xRequestDeadline, shopIDs, excludeShopIDs, paymentInstitutionRealm);
    }

}
